/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.lint.DocumentFix;
import org.eclipse.andmore.internal.refactorings.extractstring.ExtractStringRefactoring;
import org.eclipse.andmore.internal.refactorings.extractstring.ExtractStringWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

final class ExtractStringFix
extends DocumentFix {
    private ExtractStringFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        IEditorPart editorPart = AdtUtils.getActiveEditor();
        if (editorPart instanceof AndroidXmlEditor) {
            IFile file = (IFile)this.mMarker.getResource();
            TextSelection selection = new TextSelection(start, end - start);
            ExtractStringRefactoring refactoring = new ExtractStringRefactoring(file, editorPart, (ITextSelection)selection);
            ExtractStringWizard wizard = new ExtractStringWizard(refactoring, file.getProject());
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                op.run(window.getShell(), wizard.getDefaultPageTitle());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public String getDisplayString() {
        return "Extract String";
    }

    @Override
    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_OBJ_ADD");
    }
}

