/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.lint.EclipseLintRunner;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.resources.manager.GlobalProjectMonitor;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.swt.widgets.Display;

public class LintDeltaProcessor
implements Runnable {
    private List<IResource> mFiles;
    private IFile mActiveFile;
    private static GlobalProjectMonitor.IFileListener sListener;

    private LintDeltaProcessor() {
        Display display = AndmoreAndroidPlugin.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        if (display.getThread() != Thread.currentThread()) {
            display.syncExec((Runnable)this);
        } else {
            this.run();
        }
    }

    public static LintDeltaProcessor create() {
        return new LintDeltaProcessor();
    }

    public void process(IResourceDelta delta) {
        if (this.mActiveFile == null || !this.mActiveFile.getName().endsWith(".java")) {
            return;
        }
        this.mFiles = new ArrayList<IResource>();
        this.gatherFiles(delta);
        if (!this.mFiles.isEmpty()) {
            EclipseLintRunner.startLint(this.mFiles, (IResource)this.mActiveFile, null, false, false);
        }
    }

    public void process(IFile file) {
        if (this.mActiveFile == null || !this.mActiveFile.getName().endsWith(".java")) {
            return;
        }
        if (file.equals((Object)this.mActiveFile)) {
            this.mFiles = Collections.singletonList(file);
            EclipseLintRunner.startLint(this.mFiles, (IResource)this.mActiveFile, null, false, false);
        }
    }

    private void gatherFiles(IResourceDelta delta) {
        IResource resource = delta.getResource();
        String name = resource.getName();
        if (name.endsWith(".java")) {
            if (resource.equals((Object)this.mActiveFile)) {
                this.mFiles.add(resource);
            }
        } else if (name.endsWith(".class")) {
            String className = this.mActiveFile.getName();
            if (name.regionMatches(0, className, 0, className.length() - ".java".length()) && (name.length() == className.length() - ".java".length() + ".class".length() || name.charAt(className.length() - ".java".length()) == '$')) {
                this.mFiles.add(resource);
            }
        } else {
            IResourceDelta[] children = delta.getAffectedChildren();
            if (children != null && children.length > 0) {
                IResourceDelta[] iResourceDeltaArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta d = iResourceDeltaArray[n2];
                    this.gatherFiles(d);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void run() {
        this.mActiveFile = AdtUtils.getActiveFile();
    }

    public static synchronized void startListening(GlobalProjectMonitor resourceMonitor) {
        assert (sListener == null);
        sListener = new GlobalProjectMonitor.IFileListener(){

            @Override
            public void fileChanged(IFile file, IMarkerDelta[] markerDeltas, int kind, String extension, int flags, boolean isAndroidProject) {
                if (!isAndroidProject || flags == 131072) {
                    return;
                }
                if ("java".equals(extension) && !ResourceManager.isAutoBuilding() && AdtPrefs.getPrefs().isLintOnSave()) {
                    LintDeltaProcessor.create().process(file);
                }
            }
        };
        resourceMonitor.addFileListener(sListener, 5);
    }

    public static synchronized void stopListening(GlobalProjectMonitor resourceMonitor) {
        assert (sListener != null);
        resourceMonitor.removeFileListener(sListener);
        sListener = null;
    }
}

