/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.preferences;

import com.android.ide.common.xml.XmlAttributeSortOrder;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.build.DebugKeyProvider;
import com.android.sdkstats.DdmsPreferenceStore;
import java.io.File;
import java.util.Locale;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderPreviewMode;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class AdtPrefs
extends AbstractPreferenceInitializer {
    public static final String PREFS_SDK_DIR = "org.eclipse.andmore.sdk";
    public static final String PREFS_BUILD_RES_AUTO_REFRESH = "org.eclipse.andmore.resAutoRefresh";
    public static final String PREFS_BUILD_FORCE_ERROR_ON_NATIVELIB_IN_JAR = "org.eclipse.andmore.forceErrorNativeLibInJar";
    public static final String PREFS_BUILD_SKIP_POST_COMPILE_ON_FILE_SAVE = "org.eclipse.andmore.skipPostCompileOnFileSave";
    public static final String PREFS_BUILD_VERBOSITY = "org.eclipse.andmore.buildVerbosity";
    public static final String PREFS_DEFAULT_DEBUG_KEYSTORE = "org.eclipse.andmore.defaultDebugKeyStore";
    public static final String PREFS_CUSTOM_DEBUG_KEYSTORE = "org.eclipse.andmore.customDebugKeyStore";
    public static final String PREFS_HOME_PACKAGE = "org.eclipse.andmore.homePackage";
    public static final String PREFS_EMU_OPTIONS = "org.eclipse.andmore.emuOptions";
    public static final String PREFS_MONITOR_DENSITY = "org.eclipse.andmore.monitorDensity";
    public static final String PREFS_FORMAT_GUI_XML = "org.eclipse.andmore.formatXml";
    public static final String PREFS_PREFER_XML = "org.eclipse.andmore.xmlEditor";
    public static final String PREFS_USE_CUSTOM_XML_FORMATTER = "org.eclipse.andmore.androidForm";
    public static final String PREFS_PALETTE_MODE = "org.eclipse.andmore.palette";
    public static final String PREFS_USE_ECLIPSE_INDENT = "org.eclipse.andmore.eclipseIndent";
    public static final String PREVS_REMOVE_EMPTY_LINES = "org.eclipse.andmore.removeEmpty";
    public static final String PREFS_ONE_ATTR_PER_LINE = "org.eclipse.andmore.oneAttrPerLine";
    public static final String PREFS_SPACE_BEFORE_CLOSE = "org.eclipse.andmore.spaceBeforeClose";
    public static final String PREFS_FORMAT_ON_SAVE = "org.eclipse.andmore.formatOnSave";
    public static final String PREFS_LINT_ON_SAVE = "org.eclipse.andmore.lintOnSave";
    public static final String PREFS_LINT_ON_EXPORT = "org.eclipse.andmore.lintOnExport";
    public static final String PREFS_ATTRIBUTE_SORT = "org.eclipse.andmore.attrSort";
    public static final String PREFS_LINT_SEVERITIES = "org.eclipse.andmore.lintSeverities";
    public static final String PREFS_FIX_LEGACY_EDITORS = "org.eclipse.andmore.fixLegacyEditors";
    public static final String PREFS_SHARED_LAYOUT_EDITOR = "org.eclipse.andmore.sharedLayoutEditor";
    public static final String PREFS_PREVIEWS = "org.eclipse.andmore.previews";
    public static final String PREFS_SKIP_LINT_LIBS = "org.eclipse.andmore.skipLintLibs";
    public static final String PREFS_AUTO_PICK_TARGET = "org.eclipse.andmore.autoPickTarget";
    public static final String PREFS_REFACTOR_IDS = "org.eclipse.andmore.refactorIds";
    private static final AdtPrefs sThis = new AdtPrefs();
    private IPreferenceStore mStore;
    private String mOsSdkLocation;
    private BuildVerbosity mBuildVerbosity = BuildVerbosity.NORMAL;
    private boolean mBuildForceResResfresh = false;
    private boolean mBuildForceErrorOnNativeLibInJar = true;
    private boolean mBuildSkipPostCompileOnFileSave = true;
    private float mMonitorDensity = 0.0f;
    private String mPalette;
    private boolean mFormatGuiXml;
    private boolean mCustomXmlFormatter;
    private boolean mUseEclipseIndent;
    private boolean mRemoveEmptyLines;
    private boolean mOneAttributeOnFirstLine;
    private boolean mSpaceBeforeClose;
    private boolean mFormatOnSave;
    private boolean mLintOnSave;
    private boolean mLintOnExport;
    private XmlAttributeSortOrder mAttributeSort;
    private boolean mSharedLayoutEditor;
    private boolean mAutoPickTarget;
    private RenderPreviewMode mPreviewMode = RenderPreviewMode.NONE;
    private int mPreferXmlEditor;
    private boolean mSkipLibrariesFromLint;

    public static void init(IPreferenceStore preferenceStore) {
        AdtPrefs.sThis.mStore = preferenceStore;
    }

    public static AdtPrefs getPrefs() {
        return sThis;
    }

    public synchronized void loadValues(PropertyChangeEvent event) {
        String property;
        String string = property = event != null ? event.getProperty() : null;
        if (property == null || PREFS_SDK_DIR.equals(property)) {
            this.mOsSdkLocation = this.mStore.getString(PREFS_SDK_DIR);
            String override = System.getenv("ADT_TEST_SDK_PATH");
            if (override != null && override.length() > 0 && new File(override).isDirectory()) {
                this.mOsSdkLocation = override;
            }
            if (this.mOsSdkLocation.length() > 0 && !this.mOsSdkLocation.endsWith(File.separator)) {
                this.mOsSdkLocation = String.valueOf(this.mOsSdkLocation) + File.separator;
            }
        }
        if (property == null || PREFS_BUILD_VERBOSITY.equals(property)) {
            this.mBuildVerbosity = BuildVerbosity.find(this.mStore.getString(PREFS_BUILD_VERBOSITY));
            if (this.mBuildVerbosity == null) {
                this.mBuildVerbosity = BuildVerbosity.NORMAL;
            }
        }
        if (property == null || PREFS_BUILD_RES_AUTO_REFRESH.equals(property)) {
            this.mBuildForceResResfresh = this.mStore.getBoolean(PREFS_BUILD_RES_AUTO_REFRESH);
        }
        if (property == null || PREFS_BUILD_FORCE_ERROR_ON_NATIVELIB_IN_JAR.equals(property)) {
            this.mBuildForceErrorOnNativeLibInJar = this.mStore.getBoolean(PREFS_BUILD_FORCE_ERROR_ON_NATIVELIB_IN_JAR);
        }
        if (property == null || PREFS_BUILD_SKIP_POST_COMPILE_ON_FILE_SAVE.equals(property)) {
            this.mBuildSkipPostCompileOnFileSave = this.mStore.getBoolean(PREFS_BUILD_SKIP_POST_COMPILE_ON_FILE_SAVE);
        }
        if (property == null || PREFS_MONITOR_DENSITY.equals(property)) {
            this.mMonitorDensity = this.mStore.getFloat(PREFS_MONITOR_DENSITY);
        }
        if (property == null || PREFS_FORMAT_GUI_XML.equals(property)) {
            this.mFormatGuiXml = this.mStore.getBoolean(PREFS_FORMAT_GUI_XML);
        }
        if (property == null || PREFS_PREFER_XML.equals(property)) {
            this.mPreferXmlEditor = this.mStore.getInt(PREFS_PREFER_XML);
        }
        if (property == null || PREFS_USE_CUSTOM_XML_FORMATTER.equals(property)) {
            this.mCustomXmlFormatter = this.mStore.getBoolean(PREFS_USE_CUSTOM_XML_FORMATTER);
        }
        if (property == null || PREFS_PALETTE_MODE.equals(property)) {
            this.mPalette = this.mStore.getString(PREFS_PALETTE_MODE);
        }
        if (property == null || PREFS_USE_ECLIPSE_INDENT.equals(property)) {
            this.mUseEclipseIndent = this.mStore.getBoolean(PREFS_USE_ECLIPSE_INDENT);
        }
        if (property == null || PREVS_REMOVE_EMPTY_LINES.equals(property)) {
            this.mRemoveEmptyLines = this.mStore.getBoolean(PREVS_REMOVE_EMPTY_LINES);
        }
        if (property == null || PREFS_ONE_ATTR_PER_LINE.equals(property)) {
            this.mOneAttributeOnFirstLine = this.mStore.getBoolean(PREFS_ONE_ATTR_PER_LINE);
        }
        if (property == null || PREFS_ATTRIBUTE_SORT.equals(property)) {
            String order = this.mStore.getString(PREFS_ATTRIBUTE_SORT);
            this.mAttributeSort = XmlAttributeSortOrder.LOGICAL;
            if (XmlAttributeSortOrder.ALPHABETICAL.key.equals(order)) {
                this.mAttributeSort = XmlAttributeSortOrder.ALPHABETICAL;
            } else if (XmlAttributeSortOrder.NO_SORTING.key.equals(order)) {
                this.mAttributeSort = XmlAttributeSortOrder.NO_SORTING;
            }
        }
        if (property == null || PREFS_SPACE_BEFORE_CLOSE.equals(property)) {
            this.mSpaceBeforeClose = this.mStore.getBoolean(PREFS_SPACE_BEFORE_CLOSE);
        }
        if (property == null || PREFS_FORMAT_ON_SAVE.equals(property)) {
            this.mFormatOnSave = this.mStore.getBoolean(PREFS_FORMAT_ON_SAVE);
        }
        if (property == null || PREFS_LINT_ON_SAVE.equals(property)) {
            this.mLintOnSave = this.mStore.getBoolean(PREFS_LINT_ON_SAVE);
        }
        if (property == null || PREFS_LINT_ON_EXPORT.equals(property)) {
            this.mLintOnExport = this.mStore.getBoolean(PREFS_LINT_ON_EXPORT);
        }
        if (property == null || PREFS_SHARED_LAYOUT_EDITOR.equals(property)) {
            this.mSharedLayoutEditor = this.mStore.getBoolean(PREFS_SHARED_LAYOUT_EDITOR);
        }
        if (property == null || PREFS_AUTO_PICK_TARGET.equals(property)) {
            this.mAutoPickTarget = this.mStore.getBoolean(PREFS_AUTO_PICK_TARGET);
        }
        if (property == null || PREFS_PREVIEWS.equals(property)) {
            this.mPreviewMode = RenderPreviewMode.NONE;
            String previewMode = this.mStore.getString(PREFS_PREVIEWS);
            if (previewMode != null && !previewMode.isEmpty()) {
                try {
                    this.mPreviewMode = RenderPreviewMode.valueOf(previewMode.toUpperCase(Locale.US));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (property == null || PREFS_SKIP_LINT_LIBS.equals(property)) {
            this.mSkipLibrariesFromLint = this.mStore.getBoolean(PREFS_SKIP_LINT_LIBS);
        }
    }

    public synchronized String getOsSdkFolder() {
        return this.mOsSdkLocation;
    }

    public synchronized BuildVerbosity getBuildVerbosity() {
        return this.mBuildVerbosity;
    }

    public boolean getBuildForceResResfresh() {
        return this.mBuildForceResResfresh;
    }

    public boolean getFormatGuiXml() {
        return this.mFormatGuiXml && this.mCustomXmlFormatter;
    }

    public boolean getUseCustomXmlFormatter() {
        return this.mCustomXmlFormatter;
    }

    public boolean isUseEclipseIndent() {
        return this.mUseEclipseIndent;
    }

    public boolean isRemoveEmptyLines() {
        return this.mRemoveEmptyLines;
    }

    public boolean isOneAttributeOnFirstLine() {
        return this.mOneAttributeOnFirstLine;
    }

    public XmlAttributeSortOrder getAttributeSort() {
        if (this.mAttributeSort == null) {
            return XmlAttributeSortOrder.LOGICAL;
        }
        return this.mAttributeSort;
    }

    public boolean isSpaceBeforeClose() {
        return this.mSpaceBeforeClose;
    }

    public boolean isFormatOnSave() {
        return this.mFormatOnSave;
    }

    public boolean isLintOnSave() {
        return this.mLintOnSave;
    }

    public void setLintOnSave(boolean on) {
        this.mLintOnSave = on;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_LINT_ON_SAVE, on);
    }

    public boolean isLintOnExport() {
        return this.mLintOnExport;
    }

    public void setLintOnExport(boolean on) {
        this.mLintOnExport = on;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_LINT_ON_EXPORT, on);
    }

    public boolean isSharedLayoutEditor() {
        return this.mSharedLayoutEditor;
    }

    public void setSharedLayoutEditor(boolean on) {
        this.mSharedLayoutEditor = on;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_SHARED_LAYOUT_EDITOR, on);
    }

    public boolean getBuildForceErrorOnNativeLibInJar() {
        return this.mBuildForceErrorOnNativeLibInJar;
    }

    public boolean getBuildSkipPostCompileOnFileSave() {
        return this.mBuildSkipPostCompileOnFileSave;
    }

    public String getPaletteModes() {
        return this.mPalette;
    }

    public void setPaletteModes(String palette) {
        this.mPalette = palette;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_PALETTE_MODE, palette);
    }

    public float getMonitorDensity() {
        return this.mMonitorDensity;
    }

    public void setMonitorDensity(float density) {
        this.mMonitorDensity = density;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_MONITOR_DENSITY, density);
    }

    public void setSdkLocation(File location) {
        String string = this.mOsSdkLocation = location != null ? location.getPath() : null;
        if (this.mOsSdkLocation != null && this.mOsSdkLocation.length() > 0) {
            DdmsPreferenceStore ddmsStore = new DdmsPreferenceStore();
            ddmsStore.setLastSdkPath(this.mOsSdkLocation);
        }
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        store.setValue(PREFS_SDK_DIR, this.mOsSdkLocation);
    }

    public void initializeDefaultPreferences() {
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        this.initializeStoreWithDefaults(store);
    }

    public void initializeStoreWithDefaults(IPreferenceStore store) {
        store.setDefault(PREFS_BUILD_RES_AUTO_REFRESH, true);
        store.setDefault(PREFS_BUILD_FORCE_ERROR_ON_NATIVELIB_IN_JAR, true);
        store.setDefault(PREFS_BUILD_SKIP_POST_COMPILE_ON_FILE_SAVE, true);
        store.setDefault(PREFS_BUILD_VERBOSITY, BuildVerbosity.ALWAYS.name());
        store.setDefault(PREFS_HOME_PACKAGE, "android.process.acore");
        store.setDefault(PREFS_MONITOR_DENSITY, 0.0f);
        store.setDefault(PREFS_FORMAT_GUI_XML, true);
        store.setDefault(PREFS_USE_CUSTOM_XML_FORMATTER, true);
        store.setDefault(PREFS_ONE_ATTR_PER_LINE, true);
        store.setDefault(PREFS_SPACE_BEFORE_CLOSE, true);
        store.setDefault(PREFS_LINT_ON_SAVE, true);
        store.setDefault(PREFS_LINT_ON_EXPORT, true);
        store.setDefault(PREFS_AUTO_PICK_TARGET, true);
        try {
            store.setDefault(PREFS_DEFAULT_DEBUG_KEYSTORE, DebugKeyProvider.getDefaultKeyStoreOsPath());
        }
        catch (DebugKeyProvider.KeytoolException e) {
            AndmoreAndroidPlugin.log(e, "Get default debug keystore path failed", new Object[0]);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            AndmoreAndroidPlugin.log(e, "Get default debug keystore path failed", new Object[0]);
        }
    }

    public boolean isXmlEditorPreferred(int editorType) {
        return (this.mPreferXmlEditor & editorType) != 0;
    }

    public void setXmlEditorPreferred(int editorType, boolean xml) {
        if (xml != this.isXmlEditorPreferred(editorType)) {
            this.mPreferXmlEditor = xml ? (this.mPreferXmlEditor |= editorType) : (this.mPreferXmlEditor &= ~editorType);
            assert ((this.mPreferXmlEditor & editorType) != 0 == xml);
            IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
            store.setValue(PREFS_PREFER_XML, xml);
        }
    }

    public RenderPreviewMode getRenderPreviewMode() {
        return this.mPreviewMode;
    }

    public void setPreviewMode(RenderPreviewMode previewMode) {
        this.mPreviewMode = previewMode;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        if (previewMode != RenderPreviewMode.NONE) {
            store.setValue(PREFS_PREVIEWS, previewMode.name().toLowerCase(Locale.US));
        } else {
            store.setToDefault(PREFS_PREVIEWS);
        }
    }

    public boolean isAutoPickRenderTarget() {
        return this.mAutoPickTarget;
    }

    public void setAutoPickRenderTarget(boolean autoPick) {
        this.mAutoPickTarget = autoPick;
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        if (autoPick) {
            store.setToDefault(PREFS_AUTO_PICK_TARGET);
        } else {
            store.setValue(PREFS_AUTO_PICK_TARGET, autoPick);
        }
    }

    public void setSkipLibrariesFromLint(boolean exclude) {
        if (exclude != this.mSkipLibrariesFromLint) {
            this.mSkipLibrariesFromLint = exclude;
            IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
            if (exclude) {
                store.setValue(PREFS_SKIP_LINT_LIBS, true);
            } else {
                store.setToDefault(PREFS_SKIP_LINT_LIBS);
            }
        }
    }

    public boolean getSkipLibrariesFromLint() {
        return this.mSkipLibrariesFromLint;
    }

    public static enum BuildVerbosity {
        ALWAYS(0),
        NORMAL(1),
        VERBOSE(2);

        private int mLevel;

        private BuildVerbosity(int level) {
            this.mLevel = level;
        }

        public int getLevel() {
            return this.mLevel;
        }

        public static BuildVerbosity find(String name) {
            BuildVerbosity[] buildVerbosityArray = BuildVerbosity.values();
            int n = buildVerbosityArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuildVerbosity v = buildVerbosityArray[n2];
                if (v.name().equals(name)) {
                    return v;
                }
                ++n2;
            }
            return null;
        }
    }
}

