/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.preferences;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.build.DebugKeyProvider;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.preferences.Messages;
import org.eclipse.andmore.internal.utils.FingerprintUtils;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore mPrefStore = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
    private ReadOnlyFieldEditor mDefaultKeyStore = null;
    private LabelField mDefaultFingerprintMd5 = null;
    private LabelField mDefaultFingerprintSha1 = null;
    private KeystoreFieldEditor mCustomKeyStore = null;
    private LabelField mCustomFingerprintMd5 = null;
    private LabelField mCustomFingerprintSha1 = null;

    public BuildPreferencePage() {
        super(1);
        this.setPreferenceStore(this.mPrefStore);
        this.setDescription(Messages.BuildPreferencePage_Title);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.andmore.resAutoRefresh", Messages.BuildPreferencePage_Auto_Refresh_Resources_on_Build, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.andmore.forceErrorNativeLibInJar", "Force error when external jars contain native libraries", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.andmore.skipPostCompileOnFileSave", "Skip packaging and dexing until export or launch. (Speeds up automatic builds on file save)", this.getFieldEditorParent()));
        RadioGroupFieldEditor rgfe = new RadioGroupFieldEditor("org.eclipse.andmore.buildVerbosity", Messages.BuildPreferencePage_Build_Output, 1, (String[][])new String[][]{{Messages.BuildPreferencePage_Silent, AdtPrefs.BuildVerbosity.ALWAYS.name()}, {Messages.BuildPreferencePage_Normal, AdtPrefs.BuildVerbosity.NORMAL.name()}, {Messages.BuildPreferencePage_Verbose, AdtPrefs.BuildVerbosity.VERBOSE.name()}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)rgfe);
        Fingerprints defaultFingerprints = this.getFingerprints(this.mPrefStore.getString("org.eclipse.andmore.defaultDebugKeyStore"));
        this.mDefaultKeyStore = new ReadOnlyFieldEditor("org.eclipse.andmore.defaultDebugKeyStore", Messages.BuildPreferencePage_Default_KeyStore, this.getFieldEditorParent());
        this.mDefaultFingerprintMd5 = new LabelField(Messages.BuildPreferencePage_Default_Certificate_Fingerprint_MD5, defaultFingerprints != null ? defaultFingerprints.md5 : "", this.getFieldEditorParent());
        this.mDefaultFingerprintSha1 = new LabelField(Messages.BuildPreferencePage_Default_Certificate_Fingerprint_SHA1, defaultFingerprints != null ? defaultFingerprints.sha1 : "", this.getFieldEditorParent());
        this.addField((FieldEditor)this.mDefaultKeyStore);
        this.addField((FieldEditor)this.mDefaultFingerprintMd5);
        this.addField((FieldEditor)this.mDefaultFingerprintSha1);
        Fingerprints customFingerprints = null;
        String customDebugKeystorePath = this.mPrefStore.getString("org.eclipse.andmore.customDebugKeyStore");
        if (new File(customDebugKeystorePath).isFile()) {
            customFingerprints = this.getFingerprints(customDebugKeystorePath);
        } else {
            this.setErrorMessage("Not a valid keystore path.");
        }
        this.mCustomKeyStore = new KeystoreFieldEditor("org.eclipse.andmore.customDebugKeyStore", Messages.BuildPreferencePage_Custom_Keystore, this.getFieldEditorParent());
        this.mCustomFingerprintMd5 = new LabelField(Messages.BuildPreferencePage_Default_Certificate_Fingerprint_MD5, customFingerprints != null ? customFingerprints.md5 : "", this.getFieldEditorParent());
        this.mCustomFingerprintSha1 = new LabelField(Messages.BuildPreferencePage_Default_Certificate_Fingerprint_SHA1, customFingerprints != null ? customFingerprints.sha1 : "", this.getFieldEditorParent());
        this.mCustomKeyStore.setFingerprintMd5Field(this.mCustomFingerprintMd5);
        this.mCustomKeyStore.setFingerprintSha1Field(this.mCustomFingerprintSha1);
        this.addField((FieldEditor)this.mCustomKeyStore);
        this.addField((FieldEditor)this.mCustomFingerprintMd5);
        this.addField((FieldEditor)this.mCustomFingerprintSha1);
    }

    private Fingerprints getFingerprints(String keystorePath) {
        try {
            DebugKeyProvider keyProvider = new DebugKeyProvider(keystorePath, null, null);
            return new Fingerprints(FingerprintUtils.getFingerprint(keyProvider.getCertificate(), "MD5"), FingerprintUtils.getFingerprint(keyProvider.getCertificate(), "SHA1"));
        }
        catch (GeneralSecurityException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (DebugKeyProvider.KeytoolException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.setErrorMessage(e.getMessage());
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        Fingerprints defaultFingerprints = this.getFingerprints(this.mPrefStore.getString("org.eclipse.andmore.defaultDebugKeyStore"));
        this.mDefaultFingerprintMd5.setStringValue(defaultFingerprints.md5);
        this.mDefaultFingerprintSha1.setStringValue(defaultFingerprints.sha1);
        this.mCustomFingerprintMd5.setStringValue("");
        this.mCustomFingerprintSha1.setStringValue("");
    }

    private static class Fingerprints {
        final String md5;
        final String sha1;

        Fingerprints(String md5Val, String sha1Val) {
            this.md5 = md5Val;
            this.sha1 = sha1Val;
        }
    }

    private static class KeystoreFieldEditor
    extends FileFieldEditor {
        private StringFieldEditor fingerprintMd5 = null;
        private StringFieldEditor fingerprintSha1 = null;

        public void setFingerprintMd5Field(StringFieldEditor field) {
            this.fingerprintMd5 = field;
        }

        public void setFingerprintSha1Field(StringFieldEditor field) {
            this.fingerprintSha1 = field;
        }

        public KeystoreFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
            this.setValidateStrategy(0);
        }

        protected boolean checkState() {
            String fileName = this.getTextControl().getText();
            fileName = fileName.trim();
            if (this.fingerprintMd5 != null) {
                this.fingerprintMd5.setStringValue("");
            }
            if (this.fingerprintSha1 != null) {
                this.fingerprintSha1.setStringValue("");
            }
            if (fileName.length() > 0) {
                File file = new File(fileName);
                if (file.isFile()) {
                    block16: {
                        Date today;
                        X509Certificate certificate;
                        block15: {
                            block14: {
                                DebugKeyProvider provider = new DebugKeyProvider(fileName, null, null);
                                PrivateKey key = provider.getDebugKey();
                                certificate = (X509Certificate)provider.getCertificate();
                                if (key != null && certificate != null) break block14;
                                this.showErrorMessage("Unable to find debug key in keystore!");
                                return false;
                            }
                            if (this.fingerprintMd5 != null) {
                                this.fingerprintMd5.setStringValue(FingerprintUtils.getFingerprint(certificate, "MD5"));
                            }
                            if (this.fingerprintSha1 != null) {
                                this.fingerprintSha1.setStringValue(FingerprintUtils.getFingerprint(certificate, "SHA1"));
                            }
                            today = new Date();
                            if (certificate.getNotAfter().compareTo(today) >= 0) break block15;
                            this.showErrorMessage("Certificate is expired!");
                            return false;
                        }
                        if (certificate.getNotBefore().compareTo(today) <= 0) break block16;
                        this.showErrorMessage("Certificate validity is in the future!");
                        return false;
                    }
                    try {
                        this.clearErrorMessage();
                        return true;
                    }
                    catch (GeneralSecurityException e) {
                        this.handleException(e);
                        return false;
                    }
                    catch (IOException e) {
                        this.handleException(e);
                        return false;
                    }
                    catch (DebugKeyProvider.KeytoolException e) {
                        this.handleException(e);
                        return false;
                    }
                    catch (AndroidLocation.AndroidLocationException e) {
                        this.handleException(e);
                        return false;
                    }
                }
                this.showErrorMessage("Not a valid keystore path.");
                return false;
            }
            this.clearErrorMessage();
            return true;
        }

        public Text getTextControl(Composite parent) {
            this.setValidateStrategy(0);
            return super.getTextControl(parent);
        }

        private void handleException(Throwable t) {
            String msg = t.getMessage();
            if (msg == null) {
                Throwable cause = t.getCause();
                if (cause != null) {
                    this.handleException(cause);
                } else {
                    this.setErrorMessage("Uknown error when getting the debug key!");
                }
                return;
            }
            this.showErrorMessage(msg);
        }
    }

    private static class LabelField
    extends StringFieldEditor {
        private String text;

        public LabelField(String labelText, String value, Composite parent) {
            super("", labelText, parent);
            this.text = value;
        }

        protected void createControl(Composite parent) {
            super.createControl(parent);
            Text control = this.getTextControl();
            control.setEditable(false);
        }

        protected void doLoad() {
            this.setStringValue(this.text);
        }

        protected void doStore() {
        }
    }

    private static class ReadOnlyFieldEditor
    extends StringFieldEditor {
        public ReadOnlyFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void createControl(Composite parent) {
            super.createControl(parent);
            Text control = this.getTextControl();
            control.setEditable(false);
        }
    }
}

