/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.refactorings.extractstring;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.andmore.internal.refactorings.extractstring.EnabledTextEditGroup;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.text.edits.TextEditGroup;

class ReplaceStringsVisitor
extends ASTVisitor {
    private static final String CLASS_ANDROID_CONTEXT = "android.content.Context";
    private static final String CLASS_JAVA_CHAR_SEQUENCE = "java.lang.CharSequence";
    private static final String CLASS_JAVA_STRING = "java.lang.String";
    private final AST mAst;
    private final ASTRewrite mRewriter;
    private final String mOldString;
    private final String mRQualifier;
    private final String mXmlId;
    private final ArrayList<TextEditGroup> mEditGroups;

    public ReplaceStringsVisitor(AST ast, ASTRewrite astRewrite, ArrayList<TextEditGroup> editGroups, String oldString, String rQualifier, String xmlId) {
        this.mAst = ast;
        this.mRewriter = astRewrite;
        this.mEditGroups = editGroups;
        this.mOldString = oldString;
        this.mRQualifier = rQualifier;
        this.mXmlId = xmlId;
    }

    public boolean visit(StringLiteral node) {
        if (node.getLiteralValue().equals(this.mOldString)) {
            boolean useGetResource = false;
            useGetResource = this.examineVariableDeclaration(node) || this.examineMethodInvocation(node) || this.examineAssignment(node);
            Name qualifierName = this.mAst.newName(String.valueOf(this.mRQualifier) + ".string");
            SimpleName idName = this.mAst.newSimpleName(this.mXmlId);
            QualifiedName newNode = this.mAst.newQualifiedName(qualifierName, idName);
            boolean disabledChange = false;
            String title = "Replace string by ID";
            if (useGetResource) {
                SimpleName context = this.methodHasContextArgument(node);
                if (context == null && !this.isClassDerivedFromContext(node) && (context = this.findContextFieldOrMethod(node)) == null) {
                    context = this.mAst.newSimpleName("Context");
                    disabledChange = true;
                }
                MethodInvocation mi2 = this.mAst.newMethodInvocation();
                mi2.setName(this.mAst.newSimpleName("getString"));
                mi2.setExpression((Expression)context);
                mi2.arguments().add(newNode);
                newNode = mi2;
                title = "Replace string by Context.getString(R.string...)";
            }
            EnabledTextEditGroup editGroup = new EnabledTextEditGroup(title, !disabledChange);
            this.mEditGroups.add(editGroup);
            this.mRewriter.replace((ASTNode)node, (ASTNode)newNode, (TextEditGroup)editGroup);
        }
        return super.visit(node);
    }

    private boolean examineVariableDeclaration(StringLiteral node) {
        VariableDeclarationFragment fragment = this.findParentClass((ASTNode)node, VariableDeclarationFragment.class);
        if (fragment != null) {
            ASTNode parent = fragment.getParent();
            Type type = null;
            if (parent instanceof VariableDeclarationStatement) {
                type = ((VariableDeclarationStatement)parent).getType();
            } else if (parent instanceof VariableDeclarationExpression) {
                type = ((VariableDeclarationExpression)parent).getType();
            }
            if (type instanceof SimpleType) {
                return this.isJavaString(type.resolveBinding());
            }
        }
        return false;
    }

    private boolean examineAssignment(StringLiteral node) {
        Assignment assignment = this.findParentClass((ASTNode)node, Assignment.class);
        if (assignment != null) {
            Expression left = assignment.getLeftHandSide();
            ITypeBinding typeBinding = left.resolveTypeBinding();
            return this.isJavaString(typeBinding);
        }
        return false;
    }

    private boolean examineMethodInvocation(StringLiteral node) {
        MethodInvocation parent = null;
        List arguments = null;
        IMethodBinding methodBinding = null;
        MethodInvocation invoke = this.findParentClass((ASTNode)node, MethodInvocation.class);
        if (invoke != null) {
            parent = invoke;
            arguments = invoke.arguments();
            methodBinding = invoke.resolveMethodBinding();
        } else {
            ClassInstanceCreation newclass = this.findParentClass((ASTNode)node, ClassInstanceCreation.class);
            if (newclass != null) {
                parent = newclass;
                arguments = newclass.arguments();
                methodBinding = newclass.resolveConstructorBinding();
            }
        }
        if (parent != null && arguments != null && methodBinding != null) {
            StringLiteral child = null;
            StringLiteral n = node;
            while (n != parent) {
                ASTNode p = n.getParent();
                if (p == parent) {
                    child = n;
                    break;
                }
                n = p;
            }
            if (child == null) {
                return false;
            }
            int index = 0;
            for (Object arg : arguments) {
                if (arg == child) break;
                ++index;
            }
            if (index == arguments.size()) {
                return false;
            }
            boolean useStringType = false;
            ITypeBinding[] types = methodBinding.getParameterTypes();
            if (index < types.length) {
                ITypeBinding type = types[index];
                useStringType = this.isJavaString(type);
            }
            if (useStringType) {
                String name = methodBinding.getName();
                ITypeBinding clazz = methodBinding.getDeclaringClass();
                IMethodBinding[] iMethodBindingArray = clazz.getDeclaredMethods();
                int n2 = iMethodBindingArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    block15: {
                        ITypeBinding[] types2;
                        int len2;
                        IMethodBinding mb2 = iMethodBindingArray[n3];
                        if (methodBinding != mb2 && mb2.getName().equals(name) && types.length == (len2 = (types2 = mb2.getParameterTypes()).length)) {
                            int i = 0;
                            while (i < len2) {
                                ITypeBinding type2;
                                if (!(i == index ? !"int".equals((type2 = types2[i]).getQualifiedName()) : !types[i].equals((Object)types2[i]))) {
                                    ++i;
                                    continue;
                                }
                                break block15;
                            }
                            useStringType = false;
                            break;
                        }
                    }
                    ++n3;
                }
            }
            return useStringType;
        }
        return false;
    }

    private SimpleName methodHasContextArgument(StringLiteral node) {
        MethodDeclaration decl = this.findParentClass((ASTNode)node, MethodDeclaration.class);
        if (decl != null) {
            for (Object obj : decl.parameters()) {
                SingleVariableDeclaration var;
                if (!(obj instanceof SingleVariableDeclaration) || !this.isAndroidContext((var = (SingleVariableDeclaration)obj).getType())) continue;
                return this.mAst.newSimpleName(var.getName().getIdentifier());
            }
        }
        return null;
    }

    private boolean isClassDerivedFromContext(StringLiteral node) {
        TypeDeclaration clazz = this.findParentClass((ASTNode)node, TypeDeclaration.class);
        if (clazz != null) {
            return this.isAndroidContext(clazz.getSuperclassType());
        }
        return false;
    }

    private Expression findContextFieldOrMethod(StringLiteral node) {
        TypeDeclaration clazz = this.findParentClass((ASTNode)node, TypeDeclaration.class);
        return clazz == null ? null : this.findContextFieldOrMethod(clazz.resolveBinding());
    }

    private Expression findContextFieldOrMethod(ITypeBinding clazzType) {
        TreeMap<Integer, Expression> results = new TreeMap<Integer, Expression>();
        this.findContextCandidates(results, clazzType, 0);
        if (results.size() > 0) {
            Integer bestRating = results.keySet().iterator().next();
            return results.get(bestRating);
        }
        return null;
    }

    private void findContextCandidates(TreeMap<Integer, Expression> results, ITypeBinding clazzType, int superType) {
        IMethodBinding[] iMethodBindingArray = clazzType.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding mb = iMethodBindingArray[n2];
            if ((superType == 0 || !Modifier.isPrivate((int)mb.getModifiers())) && this.isAndroidContext(mb.getReturnType())) {
                int argsLen = mb.getParameterTypes().length;
                if (argsLen == 0) {
                    MethodInvocation mi = this.mAst.newMethodInvocation();
                    mi.setName(this.mAst.newSimpleName(mb.getName()));
                    results.put(Integer.MIN_VALUE, (Expression)mi);
                    return;
                }
                Integer rating = 10000 + 1000 * superType + argsLen;
                if (!results.containsKey(rating)) {
                    MethodInvocation mi = this.mAst.newMethodInvocation();
                    mi.setName(this.mAst.newSimpleName(mb.getName()));
                    results.put(rating, (Expression)mi);
                }
            }
            ++n2;
        }
        iMethodBindingArray = clazzType.getDeclaredFields();
        n = iMethodBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            IMethodBinding var = iMethodBindingArray[n2];
            if ((superType == 0 || !Modifier.isPrivate((int)var.getModifiers())) && this.isAndroidContext(var.getType())) {
                Integer rating = superType;
                results.put(rating, (Expression)this.mAst.newSimpleName(var.getName()));
                break;
            }
            ++n2;
        }
        clazzType = clazzType.getSuperclass();
        if (clazzType != null) {
            this.findContextCandidates(results, clazzType, superType + 1);
        }
    }

    private <T extends ASTNode> T findParentClass(ASTNode node, Class<T> clazz) {
        if (node != null) {
            node = node.getParent();
            while (node != null) {
                if (node.getClass().equals(clazz)) {
                    return (T)node;
                }
                node = node.getParent();
            }
        }
        return null;
    }

    private boolean isAndroidContext(Type type) {
        if (type != null) {
            return this.isAndroidContext(type.resolveBinding());
        }
        return false;
    }

    private boolean isAndroidContext(ITypeBinding type) {
        while (type != null) {
            if (CLASS_ANDROID_CONTEXT.equals(type.getQualifiedName())) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    private boolean isJavaString(ITypeBinding type) {
        while (type != null) {
            if (CLASS_JAVA_STRING.equals(type.getQualifiedName()) || CLASS_JAVA_CHAR_SEQUENCE.equals(type.getQualifiedName())) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }
}

