/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.actions;

import org.eclipse.andmore.internal.ui.IUpdateWizardDialog;
import org.eclipse.andmore.internal.ui.WizardDialogEx;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.LegacyResourceSupport;

abstract class OpenWizardAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IWorkbenchWizard mWizard;
    private int mDialogResult;
    private ISelection mSelection;
    private IWorkbench mWorkbench;

    OpenWizardAction() {
    }

    public IWorkbenchWizard getWizard() {
        return this.mWizard;
    }

    public int getDialogResult() {
        return this.mDialogResult;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IWorkbench workbench = this.mWorkbench != null ? this.mWorkbench : PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ISelection selection = this.mSelection;
        if (selection == null) {
            selection = window.getSelectionService().getSelection();
        }
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        } else {
            IWorkbenchPart part = window.getPartService().getActivePart();
            if (part instanceof IEditorPart) {
                Object file;
                IEditorInput input = ((IEditorPart)part).getEditorInput();
                Class fileClass = LegacyResourceSupport.getFileClass();
                if (input != null && fileClass != null && (file = OpenWizardAction.getAdapter(input, fileClass)) != null) {
                    selectionToPass = new StructuredSelection(file);
                }
            }
        }
        this.mWizard = this.instanciateWizard(action);
        this.mWizard.init(workbench, (IStructuredSelection)selectionToPass);
        Shell parent = window.getShell();
        WizardDialogEx dialog = new WizardDialogEx(parent, (IWizard)this.mWizard);
        dialog.create();
        if (this.mWizard instanceof IUpdateWizardDialog) {
            ((IUpdateWizardDialog)this.mWizard).updateWizardDialog(dialog);
        }
        Point defaultSize = dialog.getShell().getSize();
        dialog.getShell().setSize(Math.max(500, defaultSize.x), Math.max(500, defaultSize.y));
        window.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_wizard_shortcut_context");
        this.mDialogResult = dialog.open();
    }

    private static <T> T getAdapter(Object sourceObject, Class<T> adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        assert (adapterType != null);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return adapterType.cast(sourceObject);
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            assert (adapterType.isInstance(result2));
            return (T)result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return (T)result;
        }
        return null;
    }

    protected abstract IWorkbenchWizard instanciateWizard(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mWorkbench = targetPart.getSite().getWorkbenchWindow().getWorkbench();
    }
}

