/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newproject;

import com.android.ide.common.xml.ManifestData;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.project.ProjectChooserHelper;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectWizardState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredList;

class TestTargetPage
extends WizardPage
implements SelectionListener {
    private final NewProjectWizardState mValues;
    private boolean mIgnore;
    private String mLastExistingPackageName;
    private Button mCurrentRadioButton;
    private Button mExistingRadioButton;
    private FilteredList mProjectList;
    private boolean mPageShown;

    TestTargetPage(NewProjectWizardState values) {
        super("testTargetPage");
        this.setTitle("Select Test Target");
        this.setDescription("Choose a project to test");
        this.mValues = values;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        this.mCurrentRadioButton = new Button(container, 16);
        this.mCurrentRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mCurrentRadioButton.setText("This project");
        this.mCurrentRadioButton.addSelectionListener((SelectionListener)this);
        this.mExistingRadioButton = new Button(container, 16);
        this.mExistingRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mExistingRadioButton.setText("An existing Android project:");
        this.mExistingRadioButton.addSelectionListener((SelectionListener)this);
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        this.mProjectList = new FilteredList(container, 2820, (ILabelProvider)labelProvider, true, false, true);
        this.mProjectList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.mProjectList.addSelectionListener((SelectionListener)this);
    }

    private void initializeList() {
        ProjectChooserHelper helper = new ProjectChooserHelper(this.getShell(), null);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        Object[] androidProjects = helper.getAndroidProjects(javaModel);
        this.mProjectList.setElements(androidProjects);
        if (this.mValues.testedProject != null) {
            Object[] objectArray = androidProjects;
            int n = androidProjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                if (project.getProject() == this.mValues.testedProject) {
                    this.mProjectList.setSelection(new Object[]{project});
                    break;
                }
                ++n2;
            }
        } else {
            this.mProjectList.setSelection(new int[0]);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.mPageShown = true;
        if (visible) {
            try {
                this.mIgnore = true;
                this.mCurrentRadioButton.setSelection(this.mValues.testingSelf);
                this.mExistingRadioButton.setSelection(!this.mValues.testingSelf);
                this.mProjectList.setEnabled(!this.mValues.testingSelf);
                if (this.mProjectList.isEmpty()) {
                    this.initializeList();
                }
                if (!this.mValues.testingSelf) {
                    this.mProjectList.setFocus();
                    IProject project = this.getSelectedProject();
                    if (project != null) {
                        this.mValues.testedProject = project;
                    }
                }
            }
            finally {
                this.mIgnore = false;
            }
        }
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mExistingRadioButton) {
            this.mProjectList.setEnabled(true);
            this.mValues.testingSelf = false;
            this.setExistingProject(this.getSelectedProject());
            this.mProjectList.setFocus();
        } else if (source == this.mCurrentRadioButton) {
            this.mProjectList.setEnabled(false);
            this.mValues.testingSelf = true;
            this.mValues.testedProject = null;
        } else {
            IProject project = this.getSelectedProject();
            if (project != this.mValues.testedProject) {
                this.setExistingProject(project);
            }
        }
        this.validatePage();
    }

    private IProject getSelectedProject() {
        Object[] selection = this.mProjectList.getSelection();
        IProject project = selection != null && selection.length == 1 ? ((IJavaProject)selection[0]).getProject() : null;
        return project;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void setExistingProject(IProject project) {
        ManifestData manifestData;
        this.mValues.testedProject = project;
        if (!(project == null || this.mValues.applicationNameModifiedByUser && this.mValues.packageNameModifiedByUser && this.mValues.targetModifiedByUser && this.mValues.minSdkModifiedByUser || (manifestData = AndroidManifestHelper.parseForData(project)) == null)) {
            String appName = String.format("%1$sTest", project.getName());
            String packageName = manifestData.getPackage();
            String minSdkVersion = manifestData.getMinSdkVersionString();
            IAndroidTarget sdkTarget = null;
            if (Sdk.getCurrent() != null) {
                sdkTarget = Sdk.getCurrent().getTarget(project);
            }
            if (packageName == null) {
                packageName = "";
            }
            this.mLastExistingPackageName = packageName;
            if (!this.mValues.projectNameModifiedByUser) {
                this.mValues.projectName = appName;
            }
            if (!this.mValues.applicationNameModifiedByUser) {
                this.mValues.applicationName = appName;
            }
            if (!this.mValues.packageNameModifiedByUser) {
                this.mValues.packageName = packageName = String.valueOf(packageName) + ".test";
            }
            if (!this.mValues.targetModifiedByUser && sdkTarget != null) {
                this.mValues.target = sdkTarget;
            }
            if (!this.mValues.minSdkModifiedByUser) {
                if (minSdkVersion != null || sdkTarget != null) {
                    this.mValues.minSdk = minSdkVersion;
                }
                if (sdkTarget == null) {
                    this.mValues.updateSdkTargetToMatchMinSdkVersion();
                }
            }
        }
        this.updateTestTargetPackageField(this.mLastExistingPackageName);
    }

    private void updateTestTargetPackageField(String packageName) {
        if (this.mValues.testingSelf) {
            this.mValues.testTargetPackageName = this.mValues.packageName;
        } else if (packageName != null) {
            this.mValues.testTargetPackageName = packageName;
        }
    }

    public boolean isPageComplete() {
        if (!this.mPageShown) {
            return false;
        }
        return super.isPageComplete();
    }

    private void validatePage() {
        String error = null;
        if (!this.mValues.testingSelf) {
            if (this.mValues.testedProject == null) {
                error = "Please select an existing Android project as a test target.";
            } else if (this.mValues.projectName.equals(this.mValues.testedProject.getName())) {
                error = "The main project name and the test project name must be different.";
            }
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }
}

