/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.eclipse.andmore.AdtUtils;

public class FmActivityToLayoutMethod
implements TemplateMethodModel {
    public TemplateModel exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("Wrong arguments");
        }
        String activityName = args.get(0).toString();
        if (activityName.isEmpty()) {
            return new SimpleScalar("");
        }
        int suffixStart = activityName.lastIndexOf("Activity".charAt(0));
        if (suffixStart != -1 && activityName.regionMatches(suffixStart, "Activity", 0, activityName.length() - suffixStart)) {
            activityName = activityName.substring(0, suffixStart);
        }
        assert (!activityName.endsWith("Activity")) : activityName;
        String name = "activity_" + AdtUtils.camelCaseToUnderlines(activityName);
        return new SimpleScalar(name);
    }
}

