/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.eclipse.andmore.AdtUtils;

public class FmClassNameToResourceMethod
implements TemplateMethodModel {
    public TemplateModel exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("Wrong arguments");
        }
        String name = args.get(0).toString();
        if (name.isEmpty()) {
            return new SimpleScalar("");
        }
        name = FmClassNameToResourceMethod.stripSuffix(name, "Activity");
        name = FmClassNameToResourceMethod.stripSuffix(name, "Fragment");
        name = FmClassNameToResourceMethod.stripSuffix(name, "Service");
        name = FmClassNameToResourceMethod.stripSuffix(name, "Provider");
        return new SimpleScalar(AdtUtils.camelCaseToUnderlines(name));
    }

    private static String stripSuffix(String name, String suffix) {
        int suffixStart = name.lastIndexOf(suffix.charAt(0));
        if (suffixStart != -1 && name.regionMatches(suffixStart, suffix, 0, name.length() - suffixStart)) {
            name = name.substring(0, suffixStart);
        }
        assert (!name.endsWith(suffix)) : name;
        return name;
    }
}

