/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;

public abstract class HTMLRepeatHeaderLM
extends HTMLBlockStackingLM {
    boolean isHeaderRefined = false;
    boolean isFirstLayout = true;

    public HTMLRepeatHeaderLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    @Override
    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
        this.isHeaderRefined = false;
    }

    @Override
    protected boolean layoutChildren() throws BirtException {
        if (!this.isFirstLayout && this.shouldRepeatHeader()) {
            this.repeatHeader();
        }
        this.isFirstLayout = false;
        return super.layoutChildren();
    }

    protected abstract IBandContent getHeader();

    protected abstract boolean shouldRepeatHeader();

    protected void repeatHeader() throws BirtException {
        IBandContent header = this.getHeader();
        if (header != null) {
            this.refineBandContent(header);
            this.cleanRepeatedLayoutExtension(header);
            boolean pageBreak = this.context.allowPageBreak();
            this.context.setAllowPageBreak(false);
            IPageBuffer buffer = this.context.getPageBufferManager();
            boolean isRepeated = buffer.isRepeated();
            buffer.setRepeated(true);
            this.engine.layout((ILayoutManager)this, header, this.emitter);
            buffer.setRepeated(isRepeated);
            this.context.setAllowPageBreak(pageBreak);
        }
    }

    private void refineBandContent(IBandContent content) {
        if (this.isHeaderRefined) {
            return;
        }
        Collection children = content.getChildren();
        ArrayList<IRowContent> removed = new ArrayList<IRowContent>();
        if (children != null) {
            for (Object object : children) {
                IRowContent rowContent;
                RowDesign rowDesign;
                if (!(object instanceof IRowContent) || ((rowDesign = (RowDesign)(rowContent = (IRowContent)object).getGenerateBy()) == null || rowDesign.getRepeatable()) && rowContent.isRepeatable()) continue;
                removed.add(rowContent);
            }
            children.removeAll(removed);
        }
        this.isHeaderRefined = true;
    }

    private void cleanRepeatedLayoutExtension(IContent content) {
        Collection children = content.getChildren();
        if (children == null) {
            return;
        }
        for (IContent child : children) {
            child.setExtension(1, null);
            this.cleanRepeatedLayoutExtension(child);
        }
    }
}

