/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.IRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.AbstractTabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;

public class PropertyTabDescriptor
extends AbstractTabDescriptor
implements IRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "propertyTab";
    protected String id;
    protected String category;
    protected String label;
    protected String afterTab = null;
    protected String replaceTab = null;
    protected boolean indented = false;
    protected Image image = null;
    protected boolean popup = true;
    protected TargetRuntime targetRuntime;
    protected final IConfigurationElement configurationElement;
    protected IFile configFile;

    public PropertyTabDescriptor(IConfigurationElement e) {
        this.configurationElement = e;
        this.id = e.getAttribute("id");
        this.category = e.getAttribute("category");
        if (this.category == null || this.category.isEmpty()) {
            this.category = "BPMN2";
        }
        this.label = e.getAttribute("label");
        this.afterTab = e.getAttribute("afterTab");
        this.replaceTab = e.getAttribute("replaceTab");
        String s = e.getAttribute("indented");
        this.indented = s != null && s.trim().equalsIgnoreCase("true");
        s = e.getAttribute("popup");
        if (s != null && s.trim().equalsIgnoreCase("false")) {
            this.popup = false;
        }
        new Bpmn2SectionDescriptor(this, e);
    }

    private PropertyTabDescriptor(PropertyTabDescriptor other) {
        this.configurationElement = other.configurationElement;
        this.id = other.id;
        if (other.category == null || other.category.isEmpty()) {
            other.category = "BPMN2";
        }
        this.category = other.category;
        this.label = other.label;
    }

    @Override
    public void dispose() {
        List<IRuntimeExtensionDescriptor> list = this.targetRuntime.getRuntimeExtensionDescriptors(this.getExtensionName());
        list.remove(this);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "show.advanced.properties", null, new Object());
        for (Bpmn2Preferences p : Bpmn2Preferences.getInstances(this.targetRuntime)) {
            p.propertyChange(event);
        }
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public void setRuntime(TargetRuntime targetRuntime) {
        this.targetRuntime = targetRuntime;
        List<IRuntimeExtensionDescriptor> list = targetRuntime.getRuntimeExtensionDescriptors(this.getExtensionName());
        list.add(this);
    }

    @Override
    public TargetRuntime getRuntime() {
        return this.targetRuntime;
    }

    @Override
    public IFile getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(IFile configFile) {
        this.configFile = configFile;
    }

    public String getRuntimeId() {
        return this.targetRuntime == null ? null : this.targetRuntime.getId();
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public String getAfterTab() {
        if (this.afterTab == null || this.afterTab.trim().length() == 0) {
            return super.getAfterTab();
        }
        return this.afterTab;
    }

    public Image getImage() {
        if (this.image == null) {
            return super.getImage();
        }
        return this.image;
    }

    public TabContents createTab() {
        return super.createTab();
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    public void setSectionDescriptors(List sectionDescriptors) {
        super.setSectionDescriptors(sectionDescriptors);
    }

    public boolean isIndented() {
        return this.indented;
    }

    public Object clone() {
        PropertyTabDescriptor td = new PropertyTabDescriptor(this);
        td.afterTab = this.afterTab;
        td.replaceTab = this.replaceTab;
        if (this.image != null) {
            td.image = new Image((Device)Display.getDefault(), this.image, 0);
        }
        td.indented = this.indented;
        td.targetRuntime = this.targetRuntime;
        td.configFile = this.configFile;
        return td;
    }

    public PropertyTabDescriptor copy() {
        PropertyTabDescriptor td = new PropertyTabDescriptor(this);
        td.id = String.valueOf(td.id) + td.hashCode();
        td.afterTab = this.afterTab;
        td.replaceTab = this.replaceTab;
        if (this.image != null) {
            td.image = new Image((Device)Display.getDefault(), this.image, 0);
        }
        td.indented = this.indented;
        td.targetRuntime = this.targetRuntime;
        td.popup = this.popup;
        td.image = this.image;
        td.configFile = this.configFile;
        for (Bpmn2SectionDescriptor sd : this.getSectionDescriptors()) {
            td.getSectionDescriptors().add(new Bpmn2SectionDescriptor(td, sd));
        }
        return td;
    }

    public String getReplaceTab() {
        if (this.replaceTab == null || this.replaceTab.trim().length() == 0) {
            return null;
        }
        return this.replaceTab;
    }

    public boolean isReplacementForTab(String id) {
        String replacements = this.getReplaceTab();
        if (replacements != null) {
            String[] rep;
            String[] stringArray = rep = replacements.split(" ");
            int n = rep.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                if (r.equals(id)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

