/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;

public class RenderingAddressInfo
extends Rendering
implements IDebugContextListener,
IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener {
    private final TraditionalRendering fParent;
    private volatile Object fSelectedContext;
    private IMemoryBlockAddressInfoRetrieval fAddressInfoRetrieval = null;
    private volatile IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] fAddressInfoItems;
    private final AddressInfoTypeMap fAddressInfoTypeStatusMap = new AddressInfoTypeMap();

    public RenderingAddressInfo(Composite parent, TraditionalRendering renderingParent) {
        super(parent, renderingParent);
        this.fParent = renderingParent;
        IWorkbenchPartSite site = this.fParent.getMemoryRenderingContainer().getMemoryRenderingSite().getSite();
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)site, (IDebugContextListener)this);
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        this.resolveAddressInfoForCurrentSelection(contextService);
    }

    @Override
    void resolveAddressInfoForCurrentSelection() {
        IWorkbenchPartSite site = this.fParent.getMemoryRenderingContainer().getMemoryRenderingSite().getSite();
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        this.resolveAddressInfoForCurrentSelection(contextService);
    }

    @Override
    public void dispose() {
        this.fSelectedContext = null;
        this.fMapStartAddrToInfoItems.clear();
        this.fAddressInfoTypeStatusMap.clear();
        this.fAddressInfoItems = null;
        IWorkbenchPartSite site = this.fParent.getMemoryRenderingContainer().getMemoryRenderingSite().getSite();
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)site, (IDebugContextListener)this);
        if (this.fAddressInfoRetrieval != null) {
            this.fAddressInfoRetrieval.removeAddressInfoUpdateListener((IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener)this);
        }
        super.dispose();
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            ISelection selection = event.getContext();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            this.handleDebugContextChanged(elem);
        }
    }

    private void resolveAddressInfoForCurrentSelection(IDebugContextService contextService) {
        IWorkbenchPartSite site = this.fParent.getMemoryRenderingContainer().getMemoryRenderingSite().getSite();
        ISelection selection = contextService.getActiveContext(site.getId(), ((IViewSite)site).getSecondaryId());
        if (selection instanceof StructuredSelection) {
            this.handleDebugContextChanged(((StructuredSelection)selection).getFirstElement());
        }
    }

    private void handleDebugContextChanged(Object context) {
        if (this.isDisposed() || context == null || !this.fParent.isShowCrossRefInfoGlobalPref()) {
            return;
        }
        if (context instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)context;
            final IMemoryBlockAddressInfoRetrieval addrInfo = (IMemoryBlockAddressInfoRetrieval)adaptable.getAdapter(IMemoryBlockAddressInfoRetrieval.class);
            if (addrInfo == null) {
                return;
            }
            this.fSelectedContext = context;
            final Display display = this.getDisplay();
            addrInfo.getMemoryBlockAddressInfo(context, (IMemoryBlock)this.getMemoryBlock(), (IMemoryBlockAddressInfoRetrieval.IGetMemoryBlockAddressInfoReq)new GetMemoryBlockAddressInfoReq(this, context){

                public void done() {
                    if (this.getContext().equals(fSelectedContext)) {
                        final IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] addressInfoItems = this.getAllAddressInfoItems();
                        if (fParent.isShowCrossRefInfoGlobalPref()) {
                            final String[] types = this.getAddressInfoItemTypes();
                            if (!display.isDisposed()) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        String[] stringArray = types;
                                        int n = types.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String type = stringArray[n2];
                                            if (!fAddressInfoTypeStatusMap.containsKey(type)) {
                                                fAddressInfoTypeStatusMap.put(type, Boolean.TRUE);
                                            }
                                            ++n2;
                                        }
                                        fAddressInfoItems = addressInfoItems;
                                        fMapStartAddrToInfoItems.clear();
                                        if (fBinaryPane.isVisible()) {
                                            this.redrawPanes();
                                        }
                                        this.refreshUpdateListener(addrInfo);
                                    }
                                });
                            }
                        }
                    }
                }

                private void refreshUpdateListener(IMemoryBlockAddressInfoRetrieval addrInfo2) {
                    if (fAddressInfoRetrieval == null) {
                        fAddressInfoRetrieval = addrInfo2;
                        addrInfo2.addAddressInfoUpdateListener((IMemoryBlockAddressInfoRetrieval.IAddressInfoUpdateListener)this);
                    }
                }
            });
        }
    }

    private BigInteger getViewportEndAddressSingleHeight() {
        int cellHeight = this.fBinaryPane.getCellTextHeight() + this.getCellPadding() * 2;
        int rowCount = this.getBounds().height / cellHeight;
        BigInteger endAddress = this.fViewportAddress.add(BigInteger.valueOf(this.getBytesPerRow() * rowCount / this.getAddressableSize()));
        return endAddress;
    }

    private boolean isWithinRange(BigInteger item, BigInteger start, BigInteger end) {
        return item.compareTo(start) > -1 && item.compareTo(end) < 1;
    }

    private String[] orderTypesAscending(Set<String> items) {
        ArrayList<String> collection = new ArrayList<String>(items);
        Collections.sort(collection);
        return collection.toArray(new String[collection.size()]);
    }

    @Override
    protected void redrawPanes() {
        if (!this.isDisposed() && this.isVisible()) {
            this.getVisibleValueToAddressInfoItems();
        }
        super.redrawPanes();
    }

    public void handleAddressInfoUpdate(IMemoryBlockAddressInfoRetrieval.EventType type, Object update) {
        this.fAddressInfoItems = null;
        this.resolveAddressInfoForCurrentSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> getVisibleValueToAddressInfoItems() {
        IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] items = this.fAddressInfoItems;
        if (items == null || !this.fParent.isShowCrossRefInfoGlobalPref()) {
            this.fMapStartAddrToInfoItems.clear();
            return this.fMapStartAddrToInfoItems;
        }
        if (this.getRadix() != 1 && this.getRadix() != 5 && this.fParent.getAddressableSize() != this.getBytesPerColumn()) {
            this.fMapStartAddrToInfoItems.clear();
            return this.fMapStartAddrToInfoItems;
        }
        HashMap<BigInteger, ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> allValuesMap = new HashMap<BigInteger, ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>>(items.length);
        HashMap<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>> filteredValuesMap = new HashMap<BigInteger, List<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>>(items.length);
        Map map = this.fMapStartAddrToInfoItems;
        synchronized (map) {
            this.fMapStartAddrToInfoItems.clear();
            BigInteger startAddress = this.getViewportStartAddress();
            BigInteger endAddress = this.getViewportEndAddressSingleHeight();
            IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] iMemoryBlockAddressInfoItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem item = iMemoryBlockAddressInfoItemArray[n2];
                String itemType = item.getInfoType();
                if (this.fAddressInfoTypeStatusMap.containsKey(itemType) && !((Boolean)this.fAddressInfoTypeStatusMap.get(itemType)).equals(Boolean.FALSE)) {
                    boolean itemSpansOverVisibleRange;
                    ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem> containers = (ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>)allValuesMap.get(item.getAddress());
                    if (containers == null) {
                        containers = new ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>();
                        allValuesMap.put(item.getAddress(), containers);
                    }
                    containers.add(item);
                    BigInteger itemStart = item.getAddress();
                    BigInteger itemEnd = item.getAddress().add(item.getRangeInAddressableUnits());
                    boolean itemStartIsInRange = this.isWithinRange(itemStart, startAddress, endAddress);
                    boolean itemEndIsInRange = this.isWithinRange(itemEnd, startAddress, endAddress);
                    boolean bl = itemSpansOverVisibleRange = this.isWithinRange(startAddress, itemStart, itemEnd) && this.isWithinRange(endAddress, itemStart, itemEnd);
                    if (itemStartIsInRange || itemEndIsInRange || itemSpansOverVisibleRange) {
                        this.fMapStartAddrToInfoItems.put(item.getAddress(), (List)allValuesMap.get(item.getAddress()));
                        filteredValuesMap.put(item.getAddress(), (List)allValuesMap.get(item.getAddress()));
                    }
                }
                ++n2;
            }
        }
        return filteredValuesMap;
    }

    @Override
    String buildAddressInfoString(BigInteger cellAddress, String separator, boolean addTypeHeaders) {
        List infoItems = (List)this.fMapStartAddrToInfoItems.get(cellAddress);
        if (infoItems == null || infoItems.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, StringBuilder> infoTypeToStringBuilder = new HashMap<String, StringBuilder>();
        int i = 0;
        while (i < infoItems.size()) {
            String infoType = ((IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem)infoItems.get(i)).getInfoType();
            StringBuilder typeBuilder = (StringBuilder)infoTypeToStringBuilder.get(infoType);
            if (typeBuilder == null) {
                typeBuilder = addTypeHeaders ? new StringBuilder(infoType).append(":").append(separator) : new StringBuilder();
                infoTypeToStringBuilder.put(infoType, typeBuilder);
            }
            typeBuilder.append(((IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem)infoItems.get(i)).getLabel()).append(separator);
            ++i;
        }
        String[] sortedTypes = this.orderTypesAscending(infoTypeToStringBuilder.keySet());
        int i2 = 0;
        String[] stringArray = sortedTypes;
        int n = sortedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            StringBuilder builder = (StringBuilder)infoTypeToStringBuilder.get(type);
            String text = builder.toString();
            text = text.substring(0, text.length() - 1);
            sb.append(text);
            if (i2 < infoTypeToStringBuilder.keySet().size() - 1) {
                sb.append(separator);
            }
            ++i2;
            ++n2;
        }
        return sb.toString();
    }

    @Override
    boolean hasAddressInfo(BigInteger cellAddress) {
        return this.fMapStartAddrToInfoItems.keySet().contains(cellAddress);
    }

    @Override
    boolean hasVisibleRangeInfo() {
        return this.fBinaryPane.fPaneVisible && this.fMapStartAddrToInfoItems.size() > 0;
    }

    @Override
    public Action[] getDynamicActions() {
        ArrayList<Action> actionList = new ArrayList<Action>(this.fAddressInfoTypeStatusMap.size());
        if (this.getPaneVisible(2)) {
            for (String infoType : this.fAddressInfoTypeStatusMap.keySet()) {
                Action action = this.fAddressInfoTypeStatusMap.getAction(infoType);
                if (action == null) continue;
                actionList.add(action);
            }
        }
        return actionList.toArray(new Action[actionList.size()]);
    }

    class AddressInfoTypeMap
    extends HashMap<String, Boolean> {
        private static final long serialVersionUID = 1L;
        private final Map<String, Action> fTypeToActionMap = new HashMap<String, Action>();

        AddressInfoTypeMap() {
        }

        public Action getAction(final String infoType) {
            if (!this.containsKey(infoType)) {
                if (this.fTypeToActionMap.containsKey(infoType)) {
                    this.fTypeToActionMap.remove(infoType);
                }
                return null;
            }
            Action action = this.fTypeToActionMap.get(infoType);
            if (action != null) {
                return action;
            }
            action = new Action(infoType, 2){

                public void run() {
                    AddressInfoTypeMap.this.put(infoType, this.isChecked());
                    RenderingAddressInfo.this.redrawPanes();
                }
            };
            action.setChecked(((Boolean)this.get(infoType)).booleanValue());
            this.fTypeToActionMap.put(infoType, action);
            return action;
        }

        @Override
        public void clear() {
            this.fTypeToActionMap.clear();
            super.clear();
        }
    }

    private class GetMemoryBlockAddressInfoReq
    extends CRequest
    implements IMemoryBlockAddressInfoRetrieval.IGetMemoryBlockAddressInfoReq {
        private Map<String, IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[]> fInfoTypeToItems = Collections.synchronizedMap(new HashMap());
        private final Object fContext;

        GetMemoryBlockAddressInfoReq(Object context) {
            this.fContext = context;
        }

        public IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] getAddressInfoItems(String type) {
            return this.fInfoTypeToItems.get(type);
        }

        public void setAddressInfoItems(String type, IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] items) {
            this.fInfoTypeToItems.put(type, items);
        }

        public Object getContext() {
            return this.fContext;
        }

        public String[] getAddressInfoItemTypes() {
            return this.fInfoTypeToItems.keySet().toArray(new String[this.fInfoTypeToItems.size()]);
        }

        public IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] getAllAddressInfoItems() {
            ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem> allItemsList = new ArrayList<IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem>();
            for (IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[] partialItems : this.fInfoTypeToItems.values()) {
                if (partialItems == null || partialItems.length <= 0) continue;
                allItemsList.addAll(Arrays.asList(partialItems));
            }
            return allItemsList.toArray(new IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem[allItemsList.size()]);
        }
    }
}

