/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFHyperlinkController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFHyperlinkController
extends AbstractEEFWidgetController
implements IEEFHyperlinkController {
    private EEFHyperlinkDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<String> newValueConsumer;

    public EEFHyperlinkController(EEFHyperlinkDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        this.newEval().logIfInvalidType(String.class).call(valueExpression, this.newValueConsumer);
    }

    @Override
    public void onClick(final Object element) {
        this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String expression = EEFHyperlinkController.this.description.getOnClickExpression();
                EAttribute attr = EefPackage.Literals.EEF_HYPERLINK_DESCRIPTION__ON_CLICK_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFHyperlinkController.this.variableManager.getVariables());
                variables.put("selection", element);
                EvalFactory.of(EEFHyperlinkController.this.interpreter, variables).logIfBlank(attr).call(expression);
            }
        });
    }

    @Override
    public void onNewValue(IConsumer<String> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }
}

