/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import java.util.List;
import org.eclipse.eef.EEFReferenceDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFReferenceController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFReferenceController
extends AbstractEEFWidgetController
implements IEEFReferenceController {
    private EEFReferenceDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<Object> newValueConsumer;

    public EEFReferenceController(IVariableManager variableManager, IInterpreter interpreter, EEFReferenceDescription description, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        this.newEval().call(valueExpression, this.newValueConsumer);
    }

    @Override
    public void onNewValue(IConsumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    public void onClick(final Object element, final String onClickEventKind) {
        this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String expression = EEFReferenceController.this.description.getOnClickExpression();
                EAttribute attr = EefPackage.Literals.EEF_REFERENCE_DESCRIPTION__ON_CLICK_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFReferenceController.this.variableManager.getVariables());
                variables.put("selection", element);
                variables.put("onClickEventKind", onClickEventKind);
                EvalFactory.of(EEFReferenceController.this.interpreter, variables).logIfBlank(attr).call(expression);
            }
        });
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }

    @Override
    public void action(final EEFWidgetAction action, final List<Object> elements) {
        this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String expression = action.getActionExpression();
                EAttribute eAttribute = EefPackage.Literals.EEF_WIDGET_ACTION__ACTION_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFReferenceController.this.variableManager.getVariables());
                variables.put("selection", elements);
                EvalFactory.of(EEFReferenceController.this.interpreter, variables).logIfBlank(eAttribute).call(expression);
            }
        });
    }
}

