/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.dialogs;

import java.util.List;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.dialogs.BranchListContentProvider;
import org.eclipse.egit.gitflow.ui.internal.dialogs.DecoratedBranchLabelProvider;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class FilteredBranchesWidget {
    private TreeViewer branchesViewer;
    private final List<Ref> refs;
    private String prefix;
    private GitFlowRepository gfRepo;

    FilteredBranchesWidget(List<Ref> refs, String prefix, GitFlowRepository gfRepo) {
        this.refs = refs;
        this.prefix = prefix;
        this.gfRepo = gfRepo;
    }

    Control create(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)area);
        area.setLayout((Layout)new GridLayout(1, false));
        PatternFilter filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                TreeViewer treeViewer = (TreeViewer)viewer;
                int numberOfColumns = treeViewer.getTree().getColumnCount();
                boolean isMatch = false;
                int columnIndex = 0;
                while (columnIndex < numberOfColumns) {
                    ColumnLabelProvider labelProvider = (ColumnLabelProvider)treeViewer.getLabelProvider(columnIndex);
                    String labelText = labelProvider.getText(element);
                    isMatch |= this.wordMatches(labelText);
                    ++columnIndex;
                }
                return isMatch;
            }
        };
        filter.setIncludeLeadingWildcard(true);
        FilteredTree tree = new FilteredTree(area, 68354, filter, true);
        tree.setQuickSelectionMode(true);
        this.branchesViewer = tree.getViewer();
        this.branchesViewer.getTree().setLinesVisible(false);
        this.branchesViewer.getTree().setHeaderVisible(true);
        TreeColumn nameColumn = this.createColumn(UIText.BranchSelectionTree_NameColumn, this.branchesViewer, new DecoratedBranchLabelProvider(this.gfRepo.getRepository(), this.prefix));
        TreeColumn idColumn = this.createColumn(UIText.BranchSelectionTree_IdColumn, this.branchesViewer, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ref) {
                    ObjectId objectId = ((Ref)element).getObjectId();
                    if (objectId == null) {
                        return "";
                    }
                    return objectId.abbreviate(7).name();
                }
                return super.getText(element);
            }
        });
        TreeColumn msgColumn = this.createColumn(UIText.BranchSelectionTree_MessageColumn, this.branchesViewer, new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ref) {
                    String name = ((Ref)element).getName().substring("refs/heads/".length());
                    RevCommit revCommit = FilteredBranchesWidget.this.gfRepo.findHead(name);
                    if (revCommit == null) {
                        return "";
                    }
                    return revCommit.getShortMessage();
                }
                return super.getText(element);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.branchesViewer.getControl());
        this.branchesViewer.setContentProvider((IContentProvider)new BranchListContentProvider());
        this.branchesViewer.setComparator(new ViewerComparator(CommonUtils.STRING_ASCENDING_COMPARATOR));
        this.branchesViewer.setInput(this.refs);
        nameColumn.pack();
        idColumn.pack();
        msgColumn.pack();
        this.branchesViewer.addFilter(this.createFilter());
        return area;
    }

    private TreeColumn createColumn(String name, TreeViewer treeViewer, ColumnLabelProvider labelProvider) {
        TreeColumn column = new TreeColumn(treeViewer.getTree(), 16384);
        column.setAlignment(16384);
        column.setText(name);
        TreeViewerColumn treeViewerNameColumn = new TreeViewerColumn(treeViewer, column);
        treeViewerNameColumn.setLabelProvider((CellLabelProvider)labelProvider);
        return column;
    }

    private ViewerFilter createFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
    }

    List<Ref> getSelection() {
        return ((IStructuredSelection)this.branchesViewer.getSelection()).toList();
    }

    TreeViewer getBranchesList() {
        return this.branchesViewer;
    }
}

