/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.InitParameters;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.dialog.TitleAreaDialogSupport;
import org.eclipse.jface.databinding.dialog.ValidationMessageProvider;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class InitDialog
extends TitleAreaDialog {
    private Text developText;
    private InitParameters gitflowInitConfig = new InitParameters();
    private Text masterText;
    private Text featureText;
    private Text releaseText;
    private Text hotfixText;
    private Text versionTagText;
    private static final String DUMMY_POSTFIX = "dummy";
    private static final int TEXT_WIDTH = 100;
    private GitFlowRepository gfRepo;
    private List<Ref> branchList;

    public InitDialog(Shell parentShell, GitFlowRepository gfRepo, List<Ref> branchList) {
        super(parentShell);
        this.gfRepo = gfRepo;
        this.branchList = branchList;
    }

    public void create() {
        super.create();
        this.setTitle(UIText.InitDialog_initializeRepository);
        this.setMessage(UIText.InitDialog_chooseBranchNamesAndPrefixes);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo(container);
        this.createInputs(container);
        DataBindingContext bindingContext = this.initDataBinding();
        TitleAreaDialogSupport.create((TitleAreaDialog)this, (DataBindingContext)bindingContext).setValidationMessageProvider((IValidationMessageProvider)new ValidationMessageProvider(){

            public String getMessage(ValidationStatusProvider statusProvider) {
                if (statusProvider == null) {
                    return UIText.InitDialog_chooseBranchNamesAndPrefixes;
                }
                return super.getMessage(statusProvider);
            }

            public int getMessageType(ValidationStatusProvider statusProvider) {
                int type = super.getMessageType(statusProvider);
                Button okButton = InitDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(type != 3);
                }
                return type;
            }
        });
        return area;
    }

    private void createInputs(Composite container) {
        this.developText = this.createLabeledText(container, UIText.InitDialog_developBranch);
        this.masterText = this.createLabeledText(container, UIText.InitDialog_masterBranch);
        this.featureText = this.createLabeledText(container, UIText.InitDialog_featureBranchPrefix);
        this.releaseText = this.createLabeledText(container, UIText.InitDialog_releaseBranchPrefix);
        this.hotfixText = this.createLabeledText(container, UIText.InitDialog_hotfixBranchPrefix);
        this.versionTagText = this.createLabeledText(container, UIText.InitDialog_versionTagPrefix);
    }

    private Text createLabeledText(Composite container, String label) {
        new Label(container, 0).setText(label);
        Text result = new Text(container, 2048);
        GridDataFactory.swtDefaults().hint(100, -1).applyTo((Control)result);
        return result;
    }

    private DataBindingContext initDataBinding() {
        DataBindingContext context = new DataBindingContext();
        UpdateValueStrategy noModelToTarget = new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_ON_REQUEST);
        UpdateValueStrategy developUpdateStrategy = new UpdateValueStrategy();
        developUpdateStrategy.setBeforeSetValidator((IValidator)new BranchValidator());
        this.bind(context, noModelToTarget, developUpdateStrategy, "develop", this.developText);
        UpdateValueStrategy masterUpdateStrategy = new UpdateValueStrategy();
        masterUpdateStrategy.setBeforeSetValidator((IValidator)new BranchValidator());
        masterUpdateStrategy.setAfterConvertValidator((IValidator)new BranchExistsValidator(this.branchList));
        this.bind(context, noModelToTarget, masterUpdateStrategy, "master", this.masterText);
        UpdateValueStrategy prefixTargetToModel = new UpdateValueStrategy();
        prefixTargetToModel.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || !Repository.isValidRefName((String)("refs/heads/" + value + InitDialog.DUMMY_POSTFIX))) {
                    return Activator.error(NLS.bind((String)UIText.InitDialog_invalidPrefix, (Object)value));
                }
                return Status.OK_STATUS;
            }
        });
        this.bind(context, noModelToTarget, prefixTargetToModel, "feature", this.featureText);
        this.bind(context, noModelToTarget, prefixTargetToModel, "release", this.releaseText);
        this.bind(context, noModelToTarget, prefixTargetToModel, "hotfix", this.hotfixText);
        this.bind(context, noModelToTarget, prefixTargetToModel, "versionTag", this.versionTagText);
        context.updateTargets();
        return context;
    }

    private void bind(DataBindingContext dataBindingContext, UpdateValueStrategy noModelToTargetUpdate, UpdateValueStrategy targetToModel, String modelProperty, Text widget) {
        Binding binding = dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)widget), PojoProperties.value((String)modelProperty).observe((Object)this.gitflowInitConfig), targetToModel, noModelToTargetUpdate);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        Repository repository;
        String master = this.gitflowInitConfig.getMaster();
        if (this.isMasterBranchAvailable(master, repository = this.gfRepo.getRepository())) {
            super.okPressed();
            return;
        }
        boolean createBranch = MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.InitDialog_masterBranchIsMissing, (String)NLS.bind((String)UIText.InitDialog_selectedMasterBranchDoesNotExistCreateNow, (Object)master));
        if (!createBranch) {
            return;
        }
        try {
            RevCommit head = this.gfRepo.findHead();
            new CreateLocalBranchOperation(repository, master, head).execute(null);
        }
        catch (CoreException | WrongGitFlowStateException e) {
            throw new RuntimeException(e);
        }
        super.okPressed();
    }

    private boolean isMasterBranchAvailable(String master, Repository repository) {
        try {
            return repository.exactRef("refs/heads/" + master) != null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public InitParameters getResult() {
        return this.gitflowInitConfig;
    }

    private static final class BranchExistsValidator
    implements IValidator {
        private List<String> list = new ArrayList<String>();

        public BranchExistsValidator(List<Ref> branchList) {
            for (Ref ref : branchList) {
                this.list.add(ref.getName());
            }
        }

        public IStatus validate(Object value) {
            if (value == null || !this.list.contains("refs/heads/" + value)) {
                return Activator.warning(NLS.bind((String)UIText.InitDialog_branchDoesNotExistYetAndWillBeCreated, (Object)value));
            }
            return Status.OK_STATUS;
        }
    }

    private static final class BranchValidator
    implements IValidator {
        private BranchValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null || !Repository.isValidRefName((String)("refs/heads/" + value))) {
                return Activator.error(NLS.bind((String)UIText.InitDialog_invalidBranchName, (Object)value));
            }
            return Status.OK_STATUS;
        }
    }
}

