/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractHotfixOperation;
import org.eclipse.osgi.util.NLS;

public final class HotfixFinishOperation
extends AbstractHotfixOperation {
    public HotfixFinishOperation(GitFlowRepository repository, String hotfixName) {
        super(repository, hotfixName);
    }

    public HotfixFinishOperation(GitFlowRepository repository) throws WrongGitFlowStateException, CoreException, IOException {
        this(repository, HotfixFinishOperation.getHotfixName(repository));
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        String hotfixBranchName = this.repository.getConfig().getHotfixBranchName(this.versionName);
        String master = this.repository.getConfig().getMaster();
        this.mergeResult = this.mergeTo(monitor, hotfixBranchName, master);
        if (!this.mergeResult.getMergeStatus().isSuccessful()) {
            return;
        }
        this.safeCreateTag(monitor, this.versionName, NLS.bind((String)CoreText.HotfixFinishOperation_hotfix, (Object)this.versionName));
        this.finish(monitor, hotfixBranchName);
    }
}

