/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.InitParameters;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.GitFlowOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;

public final class InitOperation
extends GitFlowOperation {
    private String develop;
    private String master;
    private String feature;
    private String release;
    private String hotfix;
    private String versionTag;

    @Deprecated
    public InitOperation(Repository jGitRepository, String develop, String master, String feature, String release, String hotfix, String versionTag) {
        super(new GitFlowRepository(jGitRepository));
        this.develop = develop;
        this.master = master;
        this.feature = feature;
        this.release = release;
        this.hotfix = hotfix;
        this.versionTag = versionTag;
    }

    public InitOperation(@NonNull Repository jGitRepository, @NonNull InitParameters parameters) {
        super(new GitFlowRepository(jGitRepository));
        this.develop = parameters.getDevelop();
        this.master = parameters.getMaster();
        this.feature = parameters.getFeature();
        this.release = parameters.getRelease();
        this.hotfix = parameters.getHotfix();
        this.versionTag = parameters.getVersionTag();
    }

    public InitOperation(Repository repository) {
        this(repository, new InitParameters());
    }

    public InitOperation(Repository repository, String develop, String master, String featurePrefix, String releasePrefix, String hotfixPrefix) {
        this(repository, develop, master, featurePrefix, releasePrefix, hotfixPrefix, "");
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        try {
            this.setPrefixes(this.feature, this.release, this.hotfix, this.versionTag);
            this.setBranches(this.develop, this.master);
            this.repository.getRepository().getConfig().save();
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
        if (!this.repository.hasBranches()) {
            new CommitOperation(this.repository.getRepository(), this.repository.getConfig().getUser(), this.repository.getConfig().getUser(), CoreText.InitOperation_initialCommit).execute(monitor);
        }
        try {
            if (!this.isMasterBranchAvailable()) {
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.InitOperation_localMasterDoesNotExist, (Object)this.master)));
            }
            RevCommit head = this.repository.findHead();
            if (!this.repository.hasBranch(this.develop)) {
                CreateLocalBranchOperation branchFromHead = this.createBranchFromHead(this.develop, head);
                branchFromHead.execute(monitor);
                BranchOperation checkoutOperation = new BranchOperation(this.repository.getRepository(), this.develop);
                checkoutOperation.execute(monitor);
            }
        }
        catch (WrongGitFlowStateException e) {
            throw new CoreException(Activator.error(e));
        }
        catch (GitAPIException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    private void setPrefixes(String feature, String release, String hotfix, String versionTag) {
        GitFlowConfig config = this.repository.getConfig();
        config.setPrefix("feature", feature);
        config.setPrefix("release", release);
        config.setPrefix("hotfix", hotfix);
        config.setPrefix("versiontag", versionTag);
    }

    private void setBranches(String develop, String master) {
        GitFlowConfig config = this.repository.getConfig();
        config.setBranch("develop", develop);
        config.setBranch("master", master);
    }

    private boolean isMasterBranchAvailable() throws CoreException {
        try {
            return this.repository.getRepository().exactRef("refs/heads/" + this.master) != null;
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }
}

