/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOQueryQueue;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.object.CDOObjectReferenceImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequest
extends CDOClientRequest<Boolean> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryRequest.class);
    private CDOView view;
    private AbstractQueryIterator<?> queryResult;

    public QueryRequest(CDOClientProtocol protocol, CDOView view, AbstractQueryIterator<?> queryResult) {
        super(protocol, (short)17);
        this.view = view;
        this.queryResult = queryResult;
    }

    @Override
    protected CDOIDProvider getIDProvider() {
        return (InternalCDOView)this.view;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.view.getViewID());
        ((CDOQueryInfoImpl)this.queryResult.getQueryInfo()).write(out);
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        block11: {
            int queryID = in.readInt();
            this.queryResult.setQueryID(queryID);
            CDOQueryQueue resultQueue = this.queryResult.getQueue();
            boolean xrefs = this.queryResult.getQueryInfo().getQueryLanguage().equals("xrefs");
            try {
                int numberOfObjectsReceived = 0;
                while (in.readBoolean()) {
                    Object element;
                    if (xrefs) {
                        CDOIDReference delegate = in.readCDOIDReference();
                        element = new CDOObjectReferenceImpl(this.view, delegate);
                    } else {
                        element = in.readCDORevisionOrPrimitive();
                    }
                    resultQueue.add(element);
                    ++numberOfObjectsReceived;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Query executed [{0} elements received]", new Object[]{numberOfObjectsReceived});
                }
            }
            catch (RuntimeException ex) {
                resultQueue.setException((Throwable)ex);
                resultQueue.close();
                break block11;
            }
            catch (Throwable throwable) {
                try {
                    resultQueue.setException((Throwable)new RuntimeException(throwable.getMessage(), throwable));
                    break block11;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    resultQueue.close();
                }
            }
            resultQueue.close();
        }
        return true;
    }
}

