/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeatureType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.FieldInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListTableMapping
extends AbstractBasicListTableMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractListTableMapping.class);
    private IDBTable table;
    private FieldInfo[] keyFields;
    private ITypeMapping typeMapping;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsertEntry;

    public AbstractListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initTable();
        this.initSQLStrings();
    }

    private void initTable() {
        IDBField field;
        IMappingStrategy mappingStrategy = this.getMappingStrategy();
        EStructuralFeature feature = this.getFeature();
        String tableName = mappingStrategy.getTableName(this.getContainingClass(), feature);
        this.typeMapping = mappingStrategy.createValueMapping(feature);
        IDBDatabase database = mappingStrategy.getStore().getDatabase();
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            this.table = database.getSchemaTransaction().getWorkingCopy().addTable(tableName);
            IDBIndex primaryKey = this.table.addIndexEmpty(IDBIndex.Type.PRIMARY_KEY);
            FieldInfo[] fieldInfoArray = this.getKeyFields();
            int n = fieldInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldInfo info = fieldInfoArray[n2];
                IDBField field2 = this.table.addField(info.getName(), info.getType(), info.getPrecision(), true);
                primaryKey.addIndexField(field2);
                ++n2;
            }
            field = this.table.addField("CDO_IDX", DBType.INTEGER, true);
            primaryKey.addIndexField(field);
            this.typeMapping.createDBField(this.table, "CDO_VALUE");
        } else {
            this.typeMapping.setDBField(this.table, "CDO_VALUE");
        }
        Set<CDOFeatureType> forceIndexes = AbstractMappingStrategy.getForceIndexes(mappingStrategy);
        if (CDOFeatureType.matchesCombination((EStructuralFeature)feature, forceIndexes)) {
            field = this.table.getField("CDO_VALUE");
            if (!this.table.hasIndexFor(new IDBField[]{field})) {
                InternalDBIndex index = (InternalDBIndex)this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{field});
                index.setOptional(true);
            }
        }
    }

    private void initSQLStrings() {
        String tableName = this.table.getName();
        FieldInfo[] fields = this.getKeyFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("CDO_VALUE");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        int i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("=? AND ");
            } else {
                builder.append("=? ");
            }
            ++i;
        }
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY CDO_IDX";
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append("(");
        i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            builder.append(", ");
            ++i;
        }
        builder.append("CDO_IDX");
        builder.append(", ");
        builder.append("CDO_VALUE");
        builder.append(") VALUES (");
        i = 0;
        while (i < fields.length) {
            builder.append("?, ");
            ++i;
        }
        builder.append(" ?, ?)");
        this.sqlInsertEntry = builder.toString();
    }

    protected final FieldInfo[] getKeyFields() {
        if (this.keyFields == null) {
            ArrayList<FieldInfo> list = new ArrayList<FieldInfo>(3);
            IDBStore store = this.getMappingStrategy().getStore();
            DBType type = store.getIDHandler().getDBType();
            int precision = store.getIDColumnLength();
            list.add(new FieldInfo("CDO_SOURCE", type, precision));
            this.addKeyFields(list);
            this.keyFields = list.toArray(new FieldInfo[list.size()]);
        }
        return this.keyFields;
    }

    protected abstract void addKeyFields(List<FieldInfo> var1);

    protected abstract void setKeyFields(PreparedStatement var1, CDORevision var2) throws SQLException;

    @Override
    public Collection<IDBTable> getDBTables() {
        return Collections.singleton(this.table);
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final ITypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        if (listChunk == 0 || list.size() == 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            try {
                this.setKeyFields((PreparedStatement)stmt, (CDORevision)revision);
                if (TRACER.isEnabled()) {
                    TRACER.trace(stmt.toString());
                }
                if (listChunk != -1) {
                    if (stmt.getMaxRows() != listChunk) {
                        stmt.setMaxRows(listChunk);
                    }
                } else if (stmt.getMaxRows() != 0) {
                    stmt.setMaxRows(0);
                }
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    Object value = this.typeMapping.readValue((ResultSet)resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{currentIndex, value});
                    }
                    list.set(currentIndex++, value);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
        if (where != null) {
            builder.append(" AND ");
            builder.append(where);
        }
        builder.append(this.sqlOrderByIndex);
        String sql = builder.toString();
        IDBPreparedStatement stmt = chunkReader.getAccessor().getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                this.setKeyFields((PreparedStatement)stmt, chunkReader.getRevision());
                resultSet = stmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    Object value = this.typeMapping.readValue((ResultSet)resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, value);
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), idx, revision.getID(), revision.getVersion(), value});
        }
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                this.setKeyFields((PreparedStatement)stmt, revision);
                int column = this.getKeyFields().length + 1;
                stmt.setInt(column++, idx);
                this.typeMapping.setValue((PreparedStatement)stmt, column++, value);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        String tableName = this.table.getName();
        String listJoin = this.getMappingStrategy().getListJoin("a_t", "l_t");
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT l_t.");
        builder.append("CDO_SOURCE");
        builder.append(", l_t.");
        builder.append("CDO_VALUE");
        builder.append(", l_t.");
        builder.append("CDO_IDX");
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" l_t, ");
        builder.append(mainTableName);
        builder.append(" a_t WHERE ");
        builder.append("a_t." + mainTableWhere);
        builder.append(listJoin);
        builder.append(" AND ");
        builder.append("CDO_VALUE");
        builder.append(" IN ");
        builder.append(idString);
        String sql = builder.toString();
        if (TRACER.isEnabled()) {
            TRACER.format("Query XRefs (list): {0}", new Object[]{sql});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID srcId = idHandler.getCDOID((ResultSet)resultSet, 1);
                CDOID targetId = idHandler.getCDOID((ResultSet)resultSet, 2);
                int idx = resultSet.getInt(3);
                boolean more = context.addXRef(targetId, srcId, (EReference)this.getFeature(), idx);
                if (TRACER.isEnabled()) {
                    TRACER.format("  add XRef to context: src={0}, tgt={1}, idx={2}", new Object[]{srcId, targetId, idx});
                }
                if (more) continue;
                if (TRACER.isEnabled()) {
                    TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
                }
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }
}

