/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.defs.impl;

import org.eclipse.emf.cdo.defs.CDOViewDef;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.ui.defs.CDOEditorDef;
import org.eclipse.emf.cdo.ui.defs.CDOUIDefsPackage;
import org.eclipse.emf.cdo.ui.defs.impl.EditorDefImpl;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.defs.DefException;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CDOEditorDefImpl
extends EditorDefImpl
implements CDOEditorDef {
    protected CDOViewDef cdoView;
    protected static final String RESOURCE_PATH_EDEFAULT = null;
    protected String resourcePath = RESOURCE_PATH_EDEFAULT;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            Object instance = CDOEditorDefImpl.this.getInternalInstance();
            if (part == instance) {
                CDOEditorDefImpl.this.handleDeactivation(instance);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void unsetInstance() {
        this.handleDeactivation(this.getInternalInstance());
    }

    protected void handleDeactivation(Object instance) {
        CheckUtil.checkState((Object)instance, (String)"the instance ist not created yet or already close!");
        this.closeEditor((IEditorPart)((CDOEditor)instance));
        super.handleDeactivation(instance);
    }

    protected void unwireInstance(Object instance) {
        IWorkbenchWindow activeWorkbenchWindow = UIUtil.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
        }
    }

    protected void wireInstance(Object instance) {
        IWorkbenchWindow activeWorkbenchWindow = UIUtil.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.getPartService().addPartListener(this.partListener);
        }
    }

    protected CDOEditorDefImpl() {
    }

    protected EClass eStaticClass() {
        return CDOUIDefsPackage.Literals.CDO_EDITOR_DEF;
    }

    public CDOViewDef getCdoView() {
        if (this.cdoView != null && this.cdoView.eIsProxy()) {
            InternalEObject oldCdoView = (InternalEObject)this.cdoView;
            this.cdoView = (CDOViewDef)this.eResolveProxy(oldCdoView);
            if (this.cdoView != oldCdoView && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldCdoView, (Object)this.cdoView));
            }
        }
        return this.cdoView;
    }

    public CDOViewDef basicGetCdoView() {
        return this.cdoView;
    }

    public void setCdoView(CDOViewDef newCdoView) {
        CDOViewDef oldCdoView = this.cdoView;
        this.cdoView = newCdoView;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCdoView, (Object)this.cdoView));
        }
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String newResourcePath) {
        String oldResourcePath = this.resourcePath;
        this.resourcePath = newResourcePath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldResourcePath, (Object)this.resourcePath));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                if (resolve) {
                    return this.getCdoView();
                }
                return this.basicGetCdoView();
            }
            case 2: {
                return this.getResourcePath();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setCdoView((CDOViewDef)newValue);
                return;
            }
            case 2: {
                this.setResourcePath((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setCdoView(null);
                return;
            }
            case 2: {
                this.setResourcePath(RESOURCE_PATH_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.cdoView != null;
            }
            case 2: {
                return RESOURCE_PATH_EDEFAULT == null ? this.resourcePath != null : !RESOURCE_PATH_EDEFAULT.equals(this.resourcePath);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (resourcePath: ");
        result.append(this.resourcePath);
        result.append(')');
        return result.toString();
    }

    protected Object createInstance() {
        return this.openCDOEditor(this.getResourcePath());
    }

    private IEditorPart openCDOEditor(String resourcePath) {
        CDOEditorInput input = CDOEditorUtil.createCDOEditorInput((CDOView)((CDOView)this.getCdoView().getInstance()), (String)resourcePath, (boolean)false);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        CheckUtil.checkState((workbenchWindow != null && workbenchWindow.getActivePage() != null ? 1 : 0) != 0, (String)"no active window or no active page present!");
        try {
            return workbenchWindow.getActivePage().openEditor((IEditorInput)input, this.doGetEditorID());
        }
        catch (PartInitException e) {
            throw new DefException("the CDOEditor could not be opened!", (Throwable)e);
        }
    }

    private String doGetEditorID() {
        String editorID = this.getEditorID();
        if (editorID == null || editorID.length() <= 0) {
            editorID = CDOEditorUtil.getEditorID();
        }
        return editorID;
    }

    private void closeEditor(IEditorPart editorPart) {
        IWorkbenchPage workbenchPage = UIUtil.getActiveWorkbenchPage();
        if (workbenchPage != null) {
            workbenchPage.closeEditor(editorPart, true);
        }
    }

    protected void validateDefinition() {
        super.validateDefinition();
        CheckUtil.checkState((this.getResourcePath() != null && this.getResourcePath().length() > 0 ? 1 : 0) != 0, (String)"resource paths are not set!");
        CheckUtil.checkState((this.getCdoView() != null ? 1 : 0) != 0, (String)"cdo view is not set!");
    }
}

