/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.setup;

import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.UIComparison;
import org.eclipse.emf.diffmerge.ui.diffuidata.util.UidiffdataResourceFactoryImpl;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.InconsistencyDialog;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.SelectionBridge;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EMFDiffMergeEditorInput
extends CompareEditorInput {
    protected IComparisonMethod _comparisonMethod;
    protected Resource _comparisonResource;
    protected IEditableModelScope _leftScope;
    protected IEditableModelScope _rightScope;
    protected IEditableModelScope _ancestorScope;
    protected AbstractComparisonViewer _viewer;
    private boolean _foundDifferences;
    private boolean _isDirty;
    protected PropertySheetPage _propertySheetPage;
    protected CommandStackListener _commandStackListener;
    protected SelectionBridge _selectionBridge;
    private ICompareNavigator _navigator;

    public EMFDiffMergeEditorInput(IComparisonMethod method_p) {
        super(new CompareConfiguration());
        this._comparisonMethod = method_p;
        this._leftScope = null;
        this._rightScope = null;
        this._ancestorScope = null;
        this._comparisonResource = null;
        this._foundDifferences = true;
        this._isDirty = false;
        this._navigator = this.createNavigator();
        this._selectionBridge = new SelectionBridge();
        this.initializeCompareConfiguration();
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected void checkSelectionProvider() {
        IWorkbenchSite site = this.getSite();
        if (site != null && site.getSelectionProvider() != this._selectionBridge) {
            site.setSelectionProvider((ISelectionProvider)this._selectionBridge);
        }
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this._viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent ev) {
                EMFDiffMergeEditorInput.this.handleDispose();
            }
        });
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
    }

    public Control createContents(Composite parent_p) {
        this._viewer = this._comparisonMethod.createComparisonViewer(parent_p, this.getActionBars());
        if (this._selectionBridge != null) {
            this._viewer.getMultiViewerSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this._selectionBridge);
        }
        this._viewer.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                String propertyName = event_p.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean dirty = (Boolean)event_p.getNewValue();
                    EMFDiffMergeEditorInput.this.setDirty(dirty);
                }
            }
        });
        this._viewer.setInput((Object)this.getCompareResult());
        this.contentsCreated();
        return this._viewer.getControl();
    }

    protected ICompareNavigator createNavigator() {
        return new ICompareNavigator(){

            public boolean selectChange(boolean next_p) {
                int change;
                boolean result = false;
                int n = change = next_p ? 1 : 2;
                if (EMFDiffMergeEditorInput.this._viewer != null) {
                    result = EMFDiffMergeEditorInput.this._viewer.getNavigatable().selectChange(change);
                }
                return result;
            }
        };
    }

    protected String createTitle() {
        Role leftRole = EMFDiffMergeUIPlugin.getDefault().getDefaultLeftRole();
        String leftDesc = this._comparisonMethod.getModelScopeDefinition(leftRole).getShortLabel();
        String rightDesc = this._comparisonMethod.getModelScopeDefinition(leftRole.opposite()).getShortLabel();
        String result = String.format(Messages.EMFDiffMergeEditorInput_Title, leftDesc, rightDesc);
        return result;
    }

    protected void disposeResources() {
        final EditingDomain domain = this.getEditingDomain();
        final HashSet unloaded = new HashSet();
        MiscUtil.executeAndForget(domain, new Runnable(){

            public void run() {
                if (EMFDiffMergeEditorInput.this._comparisonResource != null) {
                    for (EObject root : EMFDiffMergeEditorInput.this._comparisonResource.getContents()) {
                        if (!(root instanceof UIComparison)) continue;
                        UIComparison uiComparison = (UIComparison)root;
                        uiComparison.dispose();
                    }
                    EMFDiffMergeEditorInput.this._comparisonResource.unload();
                    domain.getResourceSet().getResources().remove((Object)EMFDiffMergeEditorInput.this._comparisonResource);
                    unloaded.add(EMFDiffMergeEditorInput.this._comparisonResource);
                }
                if (EMFDiffMergeEditorInput.this._leftScope instanceof IPersistentModelScope) {
                    unloaded.addAll(((IPersistentModelScope)EMFDiffMergeEditorInput.this._leftScope).unload());
                }
                if (EMFDiffMergeEditorInput.this._rightScope instanceof IPersistentModelScope) {
                    unloaded.addAll(((IPersistentModelScope)EMFDiffMergeEditorInput.this._rightScope).unload());
                }
                if (EMFDiffMergeEditorInput.this._ancestorScope instanceof IPersistentModelScope) {
                    unloaded.addAll(((IPersistentModelScope)EMFDiffMergeEditorInput.this._ancestorScope).unload());
                }
            }
        });
        if (domain != null) {
            domain.getCommandStack().flush();
        }
        if (domain instanceof TransactionalEditingDomain) {
            for (Resource resource : unloaded) {
                TransactionUtil.disconnectFromEditingDomain((Resource)resource);
                try {
                    ResourceUndoContext context = new ResourceUndoContext((TransactionalEditingDomain)domain, resource);
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().dispose((IUndoContext)context, true, true, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void flushViewers(IProgressMonitor monitor_p) {
        this._viewer.flush(monitor_p);
    }

    public boolean foundDifferences() {
        return this._foundDifferences;
    }

    public EMFDiffNode getCompareResult() {
        return (EMFDiffNode)((Object)super.getCompareResult());
    }

    public EditingDomain getEditingDomain() {
        return this._comparisonMethod != null ? this._comparisonMethod.getEditingDomain() : null;
    }

    public synchronized ICompareNavigator getNavigator() {
        return this._navigator;
    }

    public IPropertySheetPage getPropertySheetPage() {
        EditingDomain domain;
        if (this._propertySheetPage == null && (domain = this.getEditingDomain()) instanceof AdapterFactoryEditingDomain) {
            AdapterFactoryEditingDomain afDomain = (AdapterFactoryEditingDomain)domain;
            this._propertySheetPage = new ExtendedPropertySheetPage(afDomain);
            this._propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(afDomain.getAdapterFactory()));
            this._commandStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject event_p) {
                    Shell shell = EMFDiffMergeEditorInput.this.getShell();
                    if (shell != null) {
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if ((this).EMFDiffMergeEditorInput.this._propertySheetPage != null && !(this).EMFDiffMergeEditorInput.this._propertySheetPage.getControl().isDisposed()) {
                                    (this).EMFDiffMergeEditorInput.this._propertySheetPage.refresh();
                                }
                            }
                        });
                    }
                }
            };
            afDomain.getCommandStack().addCommandStackListener(this._commandStackListener);
        }
        return this._propertySheetPage;
    }

    protected Shell getShell() {
        Shell result = null;
        IWorkbenchSite site = this.getSite();
        if (site != null) {
            result = site.getShell();
        }
        return result;
    }

    protected IWorkbenchSite getSite() {
        IWorkbenchPartSite result = null;
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null) {
            result = part.getSite();
        }
        return result;
    }

    public AbstractComparisonViewer getViewer() {
        return this._viewer;
    }

    protected void handleDispose() {
        boolean inUIThread;
        this._navigator = null;
        Display display = Display.getDefault();
        if (this._propertySheetPage != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    EMFDiffMergeEditorInput.this._propertySheetPage.dispose();
                }
            });
        }
        if (this._viewer != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    EMFDiffMergeEditorInput.this._viewer.setSelection((ISelection)StructuredSelection.EMPTY, false);
                    if (EMFDiffMergeEditorInput.this._selectionBridge != null) {
                        EMFDiffMergeEditorInput.this._viewer.getMultiViewerSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)EMFDiffMergeEditorInput.this._selectionBridge);
                        EMFDiffMergeEditorInput.this._selectionBridge = null;
                    }
                    EMFDiffMergeEditorInput.this._viewer = null;
                }
            });
        }
        if (this._commandStackListener != null && this.getEditingDomain() != null) {
            this.getEditingDomain().getCommandStack().removeCommandStackListener(this._commandStackListener);
        }
        super.handleDispose();
        Runnable disposeBehavior = new Runnable(){

            public void run() {
                if (EMFDiffMergeEditorInput.this.getCompareResult() != null) {
                    EMFDiffMergeEditorInput.this.getCompareResult().dispose();
                }
                EMFDiffMergeEditorInput.this.disposeResources();
                if (EMFDiffMergeEditorInput.this._comparisonMethod != null) {
                    EMFDiffMergeEditorInput.this._comparisonMethod.dispose();
                }
                EMFDiffMergeEditorInput.this._comparisonMethod = null;
                EMFDiffMergeEditorInput.this._ancestorScope = null;
                EMFDiffMergeEditorInput.this._leftScope = null;
                EMFDiffMergeEditorInput.this._rightScope = null;
                EMFDiffMergeEditorInput.this._comparisonResource = null;
            }
        };
        boolean bl = inUIThread = display.getThread() == Thread.currentThread();
        if (inUIThread) {
            BusyIndicator.showWhile((Display)display, (Runnable)disposeBehavior);
        } else {
            disposeBehavior.run();
        }
        try {
            super.run(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleExecutionProblem(Throwable problem_p) {
        String message;
        Throwable diagnostic = problem_p;
        if (diagnostic instanceof WrappedException) {
            diagnostic = ((WrappedException)diagnostic).exception();
        }
        if (diagnostic instanceof PackageNotFoundException) {
            PackageNotFoundException pnfe = (PackageNotFoundException)diagnostic;
            message = MiscUtil.buildString(Messages.EMFDiffMergeEditorInput_WrongMetamodel, "\n", pnfe.getLocation(), ".\n", Messages.EMFDiffMergeEditorInput_MigrationNeeded);
        } else {
            String msg = diagnostic.getLocalizedMessage();
            if (msg == null) {
                msg = diagnostic.toString();
            }
            message = MiscUtil.buildString(Messages.EMFDiffMergeEditorInput_Failure, "\n", msg);
        }
        final Shell shell = this.getShell();
        if (shell != null) {
            final String finalMessage = message;
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)shell, (String)EMFDiffMergeUIPlugin.LABEL, (String)finalMessage);
                }
            });
        }
    }

    protected void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftLabel(this._comparisonMethod.getModelScopeDefinition(Role.TARGET).getLabel());
        cc.setRightLabel(this._comparisonMethod.getModelScopeDefinition(Role.REFERENCE).getLabel());
        IModelScopeDefinition ancestorDefinition = this._comparisonMethod.getModelScopeDefinition(Role.ANCESTOR);
        cc.setAncestorLabel(ancestorDefinition == null ? "" : ancestorDefinition.getLabel());
        cc.setLeftEditable(this._comparisonMethod.getModelScopeDefinition(Role.TARGET).isEditable());
        cc.setRightEditable(this._comparisonMethod.getModelScopeDefinition(Role.REFERENCE).isEditable());
    }

    protected EComparison initializeComparison() {
        EComparisonImpl result = new EComparisonImpl(this._leftScope, this._rightScope, this._ancestorScope);
        return result;
    }

    protected EMFDiffNode initializeDiffNode(EComparison comparison_p) {
        ResourceSet resourceSet;
        ResourceSet resourceSet2 = resourceSet = this.getEditingDomain() != null ? this.getEditingDomain().getResourceSet() : null;
        if (resourceSet != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("diffuidata", new UidiffdataResourceFactoryImpl());
            String resourceURI = "platform:/resource/comparison/comparison.diffuidata";
            this._comparisonResource = resourceSet.createResource(URI.createURI((String)resourceURI));
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        EMFDiffNode result = new EMFDiffNode(comparison_p, this.getEditingDomain(), cc.isLeftEditable(), cc.isRightEditable());
        result.setReferenceRole(this._comparisonMethod.getTwoWayReferenceRole());
        result.updateDifferenceNumbers();
        return result;
    }

    public boolean isSaveNeeded() {
        this.checkSelectionProvider();
        return this._isDirty;
    }

    protected void loadScopes(IProgressMonitor monitor_p) {
        EditingDomain domain = this.getEditingDomain();
        boolean threeWay = this._comparisonMethod.isThreeWay();
        Role leftRole = EMFDiffMergeUIPlugin.getDefault().getDefaultLeftRole();
        String mainTaskName = Messages.EMFDiffMergeEditorInput_Loading;
        SubMonitor loadingMonitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)mainTaskName, (int)(threeWay ? 4 : 3));
        loadingMonitor.worked(1);
        loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingLeft);
        EditingDomain leftLoadingContext = domain != null ? domain : this._comparisonMethod.getResourceSet(leftRole);
        this._leftScope = this._comparisonMethod.getModelScopeDefinition(leftRole).createScope(leftLoadingContext);
        if (this._leftScope == null) {
            throw new RuntimeException(Messages.EMFDiffMergeEditorInput_LeftScopeNull);
        }
        if (this._leftScope instanceof IPersistentModelScope) {
            try {
                ((IPersistentModelScope)this._leftScope).load();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        loadingMonitor.worked(1);
        if (loadingMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingRight);
        EditingDomain rightLoadingContext = domain != null ? domain : this._comparisonMethod.getResourceSet(leftRole.opposite());
        this._rightScope = this._comparisonMethod.getModelScopeDefinition(leftRole.opposite()).createScope(rightLoadingContext);
        if (this._rightScope == null) {
            throw new RuntimeException(Messages.EMFDiffMergeEditorInput_RightScopeNull);
        }
        if (this._rightScope instanceof IPersistentModelScope) {
            try {
                ((IPersistentModelScope)this._rightScope).load();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        loadingMonitor.worked(1);
        if (loadingMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (threeWay) {
            loadingMonitor.subTask(Messages.EMFDiffMergeEditorInput_LoadingAncestor);
            EditingDomain ancestorLoadingContext = domain != null ? domain : this._comparisonMethod.getResourceSet(Role.ANCESTOR);
            this._ancestorScope = this._comparisonMethod.getModelScopeDefinition(Role.ANCESTOR).createScope(ancestorLoadingContext);
            if (this._ancestorScope == null) {
                throw new RuntimeException(Messages.EMFDiffMergeEditorInput_AncestorScopeNull);
            }
            if (this._ancestorScope instanceof IPersistentModelScope) {
                try {
                    ((IPersistentModelScope)this._ancestorScope).load();
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
            loadingMonitor.worked(1);
            if (loadingMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    public boolean mergeIsComplete() {
        return !this.isDirty() && (this._viewer.getInput() == null || this._viewer.getInput().isEmpty());
    }

    protected Object prepareInput(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        if (monitor_p == null) {
            return null;
        }
        String title = this.createTitle();
        this.setTitle(title);
        boolean scopesReady = this._leftScope != null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)EMFDiffMergeUIPlugin.LABEL, (int)2);
        EMFDiffNode result = null;
        try {
            if (!scopesReady) {
                this.loadScopes((IProgressMonitor)monitor.newChild(1));
            }
            EComparison comparison = this.initializeComparison();
            comparison.compute(this._comparisonMethod.getMatchPolicy(), this._comparisonMethod.getDiffPolicy(), this._comparisonMethod.getMergePolicy(), (IProgressMonitor)monitor.newChild(scopesReady ? 2 : 1));
            if (!comparison.isConsistent()) {
                this.handleInconsistency((IComparison)comparison);
            }
            this._foundDifferences = comparison.hasRemainingDifferences();
            if (this._foundDifferences) {
                result = this.initializeDiffNode(comparison);
            } else {
                this.handleDispose();
            }
        }
        catch (OperationCanceledException e) {
            this.handleDispose();
        }
        catch (Throwable t) {
            this.setMessage(Messages.EMFDiffMergeEditorInput_CannotLoad);
            this.handleExecutionProblem(t);
            this.handleDispose();
        }
        return result;
    }

    protected void handleInconsistency(final IComparison comparison_p) {
        final Shell shell = this.getShell();
        if (shell != null) {
            final int[] pressed = new int[1];
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dialog = new MessageDialog(shell, EMFDiffMergeUIPlugin.LABEL, null, Messages.InconsistencyDialog_DuplicateIDs, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL}, 0);
                    pressed[0] = dialog.open();
                }
            });
            if (pressed[0] != 0) {
                shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        InconsistencyDialog dialog = new InconsistencyDialog(shell, comparison_p);
                        dialog.open();
                    }
                });
            }
        }
    }

    public void run(IProgressMonitor monitor_p) throws InterruptedException, InvocationTargetException {
        EditingDomain domain;
        if (this.getCompareResult() != null) {
            this.getCompareResult().dispose();
        }
        super.run(monitor_p);
        if (this.getCompareResult() != null && this.foundDifferences() && this._comparisonResource != null && (domain = this.getEditingDomain()) != null) {
            MiscUtil.executeAndForget(domain, new Runnable(){

                public void run() {
                    EMFDiffMergeEditorInput.this._comparisonResource.getContents().add((Object)EMFDiffMergeEditorInput.this.getCompareResult().getUIComparison());
                }
            });
            domain.getCommandStack().flush();
        }
    }

    public void setDirty(boolean dirty_p) {
        boolean oldDirty = this.isDirty();
        if (dirty_p != oldDirty) {
            this._isDirty = dirty_p;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)oldDirty, (Object)this._isDirty);
            this.firePropertyChange(event);
        }
    }

    public boolean setFocus2() {
        boolean result = false;
        if (this._viewer != null) {
            result = this._viewer.getControl().setFocus();
        }
        return result;
    }
}

