/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.di;

import static com.google.common.base.Preconditions.checkNotNull;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.IDEConstants.BUNDLE_ID;
import static org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin;

import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;

public class ImageRegistryCreationFunction extends ContextFunction {

    public static final String IMG_WIZBAN = "icons/wizban/stacktraces_wiz.png"; //$NON-NLS-1$
    public static final String ICO_ANONMYIZE_MESSAGE = "icons/obj16/usr-no.png"; //$NON-NLS-1$
    public static final String ICO_ANONMYIZE_STACKTRACE = "icons/obj16/stcktrc-no.png"; //$NON-NLS-1$
    public static final String ICO_INFO = "icons/obj16/message_info.png"; //$NON-NLS-1$

    @Override
    public Object compute(IEclipseContext context, String contextKey) {
        Display display = checkNotNull(context.get(Display.class));
        ImageRegistry registry = new ImageRegistry(display);
        checkNotNull(registry);
        registry.put(IMG_WIZBAN, imageDescriptorFromPlugin(BUNDLE_ID, IMG_WIZBAN));
        registry.put(ICO_ANONMYIZE_MESSAGE, imageDescriptorFromPlugin(BUNDLE_ID, ICO_ANONMYIZE_MESSAGE));
        registry.put(ICO_ANONMYIZE_STACKTRACE, imageDescriptorFromPlugin(BUNDLE_ID, ICO_ANONMYIZE_STACKTRACE));
        registry.put(ICO_INFO, imageDescriptorFromPlugin(BUNDLE_ID, ICO_INFO));

        IEclipseContext systemContext = SystemControl.getSystemContext();
        systemContext.set(contextKey, registry);
        return registry;
    }
}
