/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.l10n;

import static org.eclipse.core.runtime.IStatus.ERROR;
import static org.eclipse.core.runtime.IStatus.INFO;
import static org.eclipse.core.runtime.IStatus.WARNING;

import org.eclipse.epp.logging.aeri.core.util.Logs.DefaultLogMessage;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@SuppressWarnings("null")
public final class LogMessages extends DefaultLogMessage {

    public static final Bundle BUNDLE = FrameworkUtil.getBundle(LogMessages.class);
    // Unit tests should not fails because OSGI is not yet available:
    private static final String VERSION = "; version: " //$NON-NLS-1$
            + (BUNDLE == null ? "unit-tests" : BUNDLE.getVersion().toString()); //$NON-NLS-1$
    private static int code = 1;

    public static final LogMessages DEBUG_HISTORY_REMEMBER_STATUS = new LogMessages(INFO, Messages.LOG_DEBUG_HISTORY_REMEMBER_STATUS);
    public static final LogMessages DEBUG_NOTIFICATION_IN_PROGRESS = new LogMessages(INFO, Messages.LOG_DEBUG_NOTIFICATION_IN_PROGRESS);
    public static final LogMessages DEBUG_UNKNOWN_SERVER_STATUS = new LogMessages(INFO, Messages.LOG_DEBUG_UNKNOWN_SERVER_STATUS);
    public static final LogMessages DEBUG_UNKNOWN_SERVER_STATUS_IN_REMOTE_HISTORY = new LogMessages(INFO,
            Messages.LOG_DEBUG_UNKNOWN_SERVER_STATUS_IN_REMOTE_HISTORY);

    public static final LogMessages ERROR_FAILED_TO_PARSE_PREFERENCE_VALUE = new LogMessages(ERROR,
            Messages.LOG_ERROR_FAILED_TO_PARSE_PREFERENCE_VALUE);
    public static final LogMessages ERROR_SAVE_PREFERENCES_FAILED = new LogMessages(ERROR, Messages.LOG_ERROR_SAVE_PREFERENCES_FAILED);

    public static final LogMessages INFO_SERVER_NOT_AVAILABLE = new LogMessages(INFO, Messages.LOG_INFO_SERVER_NOT_AVAILABLE);

    public static final LogMessages WARN_HISTORY_NOT_AVAILABLE = new LogMessages(WARNING, Messages.LOG_WARN_HISTORY_NOT_AVAILABLE);
    public static final LogMessages WARN_HISTORY_STOP_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_HISTORY_STOP_FAILED);
    public static final LogMessages WARN_INDEX_UPDATE_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_INDEX_UPDATE_FAILED);
    public static final LogMessages WARN_INVALID_PATTERN = new LogMessages(WARNING, Messages.LOG_WARN_INVALID_PATTERN);
    public static final LogMessages WARN_EXTENSION_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_EXTENSION_FAILED);
    public static final LogMessages WARN_FORMATTING_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_FORMATTING_FAILED);
    public static final LogMessages WARN_REPORTING_ERROR = new LogMessages(WARNING, Messages.LOG_WARN_REPORTING_ERROR);
    public static final LogMessages WARN_OPEN_BROWSER_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_OPEN_BROSER_FAILED);
    public static final LogMessages WARN_SERVER_FAILURE = new LogMessages(WARNING, Messages.LOG_WARN_SERVER_FAILURE);
    public static final LogMessages WARN_INDEX_NOT_AVAILABLE = new LogMessages(WARNING, Messages.LOG_WARN_INDEX_NOT_AVAILABLE);
    public static final LogMessages WARN_URL_VALIDATION_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_URL_VALIDATION_FAILED);
    public static final LogMessages WARN_RESPONSE_UPLOAD_REPORT_FAILED = new LogMessages(WARNING,
            Messages.LOG_WARN_RESPONSE_UPLOAD_REPORT_FAILED);
    public static final LogMessages WARN_UNEXPECTED_SERVER_RESPONSE = new LogMessages(WARNING, Messages.LOG_WARN_UNEXECTED_SERVER_RESPONSE);
    public static final LogMessages WARN_REPORT_PROCESSOR_FAILED = new LogMessages(WARNING, Messages.LOG_WARN_REPORT_PROCESSOR_FAILED);

    public LogMessages(int severity, String message) {
        super(severity, code++, String.format("%s %s", message, VERSION)); //$NON-NLS-1$
    }

    public LogMessages(int severity, int code, String message) {
        super(severity, code, String.format("%s %s", message, VERSION)); //$NON-NLS-1$
    }

    @Override
    public Bundle bundle() {
        return BUNDLE;
    }
}
