/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.l10n;

import org.eclipse.osgi.util.NLS;

public class Messages extends NLS {
    private static final String BUNDLE_NAME = "org.eclipse.epp.internal.logging.aeri.ide.l10n.messages"; //$NON-NLS-1$

    public static String BUTTON_TEXT_CONFIGURE_SERVERS;
    public static String BUTTON_TEXT_DISABLE;
    public static String BUTTON_TEXT_DISABLED;
    public static String BUTTON_TEXT_DONT_SEND;
    public static String BUTTON_TEXT_ENABLE;
    public static String BUTTON_TEXT_ENABLED;
    public static String BUTTON_TEXT_SEND;

    public static String COMMENT_PROBLEMATIC_PACKAGE_IMPORT;
    public static String COMMENT_PROBLEMATIC_PACKAGE_IMPORTS;
    public static String COMMENT_PROBLEMATIC_PACKAGE_ORIGIN_EXPORTS;

    public static String COMBO_TEXT_SEVERITY_UNKNOWN;

    public static String DIALOG_MESSAGE_CONFIGURE_SERVER;
    public static String DIALOG_MESSAGE_EXTERNAL_SERVERS_ENABLED;
    public static String DIALOG_MESSAGE_REVIEW;

    public static String DIALOG_TITLE_CONFIGURE_SERVER;
    public static String DIALOG_TITLE_EXTERNAL_SERVERS_ENABLED;
    public static String DIALOG_TITLE_REVIEW;

    public static String FIELD_LABEL_ANONYMIZE_MESSAGES;
    public static String FIELD_LABEL_ANONYMIZE_STACKTRACES;

    public static String FIELD_LABEL_DISABLE_AUTOMATIC_WIRING_ANALYSIS;
    public static String FIELD_LABEL_EMAIL;
    public static String FIELD_LABEL_ENABLE_DEBUG;
    public static String FIELD_LABEL_NAME;
    public static String FIELD_MESSAGE_EMAIL;
    public static String FIELD_MESSAGE_NAME;

    public static String FORMATTING_LIST_SEPARATOR;
    public static String FORMATTING_LIST_SEPARATOR_LAST;
    public static String FORMATTING_MORE_PROJECTS;
    public static String FORMATTING_ONE_PROJECT;
    public static String FORMATTING_TWO_PROJECTS;
    public static String FORMATTING_THREE_PROJECTS;
    public static String FORMATTING_X_PROJECTS;
    public static String FORMATTING_ZERO_PROJECTS;

    public static String GROUP_TEXT_ANONYMIZATION;
    public static String GROUP_TEXT_CONTACT_INFORMATION;

    public static String JOB_NAME_INITIALIZING_AERI;
    public static String JOB_NAME_UPDATE_INDEX;
    public static String JOB_NAME_UPLOADING_REPORTS;

    public static String JOB_PROGRESS_LABEL_HTTP;

    public static String JOB_TASK_NAME_CHECKING_INDEX;
    public static String JOB_TASK_NAME_CHECKING_REMOTE_STATUS;
    public static String JOB_TASK_NAME_REPLACING_LOCAL_DATABASE;

    public static String LABEL_SERVER_PROVIDER;
    public static String LABEL_TEXT_EVENTS;
    public static String LABEL_TEXT_SEND_MODE;

    public static String LINK_TEXT_BUG;
    public static String LINK_TEXT_BUG_ID_NULL;
    public static String LINK_TEXT_CONFIGURE;
    public static String LINK_TEXT_DEFAULT_MESSAGE_CONFIRMED_PROBLEM;
    public static String LINK_TEXT_DEFAULT_MESSAGE_FAILURE;
    public static String LINK_TEXT_DEFAULT_MESSAGE_FIXED_PROBLEM;
    public static String LINK_TEXT_DEFAULT_MESSAGE_IGNORED_PROBLEM;
    public static String LINK_TEXT_DEFAULT_MESSAGE_INVALID_PROBLEM;
    public static String LINK_TEXT_DEFAULT_MESSAGE_NEEDINFO_PROBLEM;
    public static String LINK_TEXT_DEFAULT_MESSAGE_NEW_PROBLEM;
    public static String LINK_TEXT_DEFAULT_MESSAGE_UNCONFIRMED_PROBLEM;
    public static String LINK_TEXT_DO_YOU_WANT_TO_REPORT_ERROR;
    public static String LINK_TEXT_ENABLE_ADMONITION_WITH_PRIVACY_POLICY;
    public static String LINK_TEXT_ENABLE_ADMONITION_WITH_TERMS_OF_USE;
    public static String LINK_TEXT_ENABLE_ADMONITION_WITH_TERMS_OF_USE_AND_PRIVACY_POLICY;
    public static String LINK_TEXT_ENABLEMENT_ADMONITION;
    public static String LINK_TEXT_LEARN_MORE;
    public static String LINK_TEXT_MISSING_DESCRIPTION;
    public static String LINK_TEXT_NOTIFICATION_PREFERENCE_PAGE;
    public static String LINK_TEXT_PRIVACY_POLICY;
    public static String LINK_TEXT_SEND;
    public static String LINK_TEXT_SENDING_PREFERENCES;
    public static String LINK_TEXT_SUBMISSION;
    public static String LINK_TEXT_TERMS_OF_USE;
    public static String LINK_TEXT_VIEW_DETAILS;

    public static String LINK_TOOLTIP_MISSING_URL;

    public static String LIST_HEADER_INTERESTED_PROJECTS;

    public static String LOG_DEBUG_HISTORY_REMEMBER_STATUS;
    public static String LOG_DEBUG_NOTIFICATION_IN_PROGRESS;
    public static String LOG_DEBUG_UNKNOWN_SERVER_STATUS;
    public static String LOG_DEBUG_UNKNOWN_SERVER_STATUS_IN_REMOTE_HISTORY;

    public static String LOG_ERROR_FAILED_TO_PARSE_PREFERENCE_VALUE;
    public static String LOG_ERROR_SAVE_PREFERENCES_FAILED;

    public static String LOG_HISTORY_ABBREVIATION;

    public static String LOG_INFO_SERVER_NOT_AVAILABLE;

    public static String LOG_WARN_EXTENSION_FAILED;
    public static String LOG_WARN_FORMATTING_FAILED;
    public static String LOG_WARN_HISTORY_NOT_AVAILABLE;
    public static String LOG_WARN_HISTORY_STOP_FAILED;
    public static String LOG_WARN_INDEX_NOT_AVAILABLE;
    public static String LOG_WARN_INDEX_UPDATE_FAILED;
    public static String LOG_WARN_INVALID_PATTERN;
    public static String LOG_WARN_OPEN_BROSER_FAILED;
    public static String LOG_WARN_REPORT_PROCESSOR_FAILED;
    public static String LOG_WARN_REPORTING_ERROR;
    public static String LOG_WARN_RESPONSE_UPLOAD_REPORT_FAILED;
    public static String LOG_WARN_SERVER_FAILURE;
    public static String LOG_WARN_UNEXECTED_SERVER_RESPONSE;
    public static String LOG_WARN_URL_VALIDATION_FAILED;

    public static String NOTIFICATION_ACTION_DISABLE;
    public static String NOTIFICATION_ACTION_ENABLE;

    public static String NOTIFICATION_TITLE_ERROR_REPORTING;
    public static String NOTIFICATION_TITLE_NEW_EVENT;
    public static String NOTIFICATION_TITLE_PREFIX_WAITING_FOR_FOCUS;
    public static String NOTIFICATION_TITLE_SERVER_RESPONSES;
    public static String NOTIFICATION_TITLE_SETUP_NEW_SERVERS;
    public static String NOTIFICATION_TITLE_SETUP_NEW_SERVERS_1_ADDITIONAL_SERVER;
    public static String NOTIFICATION_TITLE_SETUP_NEW_SERVERS_2_ADDITIONAL_SERVERS;
    public static String NOTIFICATION_TITLE_SETUP_NEW_SERVERS_X_ADDITIONAL_SERVERS;
    public static String NOTIFICATION_TITLE_SETUP_SYSTEM;

    public static String NOTIFICATION_DESCRIPTION_NEW_EVENT;
    public static String NOTIFICATION_DESCRIPTION_SERVER_RESPONSES;
    public static String NOTIFICATION_DESCRIPTION_SETUP_NEW_SERVERS;
    public static String NOTIFICATION_DESCRIPTION_SETUP_SYSTEM;

    public static String NOTIFICATION_LABEL_NEW_EVENT;
    public static String NOTIFICATION_LABEL_SETUP_NEW_SERVERS;
    public static String NOTIFICATION_LABEL_SETUP_SYSTEM;

    public static String NOTIFY_INTEREST_MESSAGE_ENPOINT_FAILED;
    public static String NOTIFY_INTEREST_PROBLEM_CONFIRMED;
    public static String NOTIFY_INTEREST_PROBLEM_FAILURE;
    public static String NOTIFY_INTEREST_PROBLEM_FIXED;
    public static String NOTIFY_INTEREST_PROBLEM_IGNORED;
    public static String NOTIFY_INTEREST_PROBLEM_INVALID;
    public static String NOTIFY_INTEREST_PROBLEM_NEEDINFO;
    public static String NOTIFY_INTEREST_PROBLEM_NEW;
    public static String NOTIFY_INTEREST_PROBLEM_UNCONFIRMED;

    public static String PREFERENCE_PAGE_DESCRIPTION;

    public static String PROBLEM_MESSAGES_CONFIRMED_BUG_AFTER_SEND;
    public static String PROBLEM_MESSAGES_CONFIRMED_NO_BUG_AFTER_SEND;
    public static String PROBLEM_MESSAGES_FIXED_BUG_AFTER_SEND;
    public static String PROBLEM_MESSAGES_FIXED_BUG_BEFORE_SEND;
    public static String PROBLEM_MESSAGES_FIXED_NO_BUG_AFTER_SEND;
    public static String PROBLEM_MESSAGES_FIXED_NO_BUG_BEFORE_SEND;
    public static String PROBLEM_MESSAGES_FORWARD_SERVER_RESPONSE;
    public static String PROBLEM_MESSAGES_NEEDINFO_BUG_AFTER_SEND;
    public static String PROBLEM_MESSAGES_NEEDINFO_BUG_BEFORE_SEND;
    public static String PROBLEM_MESSAGES_NEEDINFO_NO_BUG_AFTER_SEND;
    public static String PROBLEM_MESSAGES_NEEDINFO_NO_BUG_BEFORE_SEND;
    public static String PROBLEM_MESSAGES_WONTFIX_BUG_BEFORE_SEND;
    public static String PROBLEM_MESSAGES_WONTFIX_NO_BUG_BEFORE_SEND;

    public static String PROBLEM_MESSAGES_NEW_AFTER_SEND;
    public static String PROBLEM_MESSAGES_UNCONFIRMED_AFTER_SEND;
    public static String PROBLEM_MESSAGES_UNCONFIRMED_BEFORE_SEND;

    public static String SEND_MODE_BACKGROUND_LABEL;
    public static String SEND_MODE_NEVER_LABEL;
    public static String SEND_MODE_NOTIFY_LABEL;

    public static String STATUS_TITLE_CONFIRMED;

    public static String STATUS_TITLE_FAILURE;

    public static String STATUS_TITLE_FIXED;

    public static String STATUS_TITLE_IGNORED;

    public static String STATUS_TITLE_INVALID;

    public static String STATUS_TITLE_NEEDINFO;

    public static String STATUS_TITLE_NEW;

    public static String STATUS_TITLE_UNCONFIRMED;

    public static String STYLED_TEXT_PREVIEW;

    public static String PROBLEM_MESSAGES_SERVER_FAILURE;
    public static String PROBLEM_MESSAGES_IGNORED_OR_INVALID_STATUS;

    public static String TASK_NAME_INITIALIZING_AERI;

    public static String TOGGLE_TOOLTIP_ANONYMIZE_MESSAGES;
    public static String TOGGLE_TOOLTIP_ANONYMIZE_STACKTRACE;

    public static String TOOLTIP_COMMENTS;

    public static String TOOLTIP_DISABLE_AUTOMATIC_WIRING_ANALYSIS;
    public static String TOOLTIP_ENABLE_DEBUG;
    public static String TOOLTIP_SEND_MODE;
    public static String TOOLTIP_SETTINGS_EMAIL;
    public static String TOOLTIP_SETTINGS_MAKE_MESSAGES_ANONYMOUS;
    public static String TOOLTIP_SETTINGS_MAKE_STACKTRACE_ANONYMOUS;

    public static String TWISTIE_TEXT_COMMENT;
    public static String TWISTIE_TEXT_PREVIEW;

    public static String RESPONSE_REPORT_UPLOAD_FAILED;
    public static String RESPONSE_REPORT_UPLOADED;

    public static String WIZARD_TITLE_SETUP;

    public static String WIZPAGE_DESCRIPTION_ECLIPSE_SERVER;
    public static String WIZPAGE_DESCRIPTION_SERVERS;
    public static String WIZPAGE_DESCRIPTION_SYSTEM_SETTINGS;

    public static String WIZPAGE_TITLE_ECLIPSE_SERVER;
    public static String WIZPAGE_TITLE_SERVERS;
    public static String WIZPAGE_TITLE_SYSTEM_SETTINGS;

    static {
        // initialize resource bundle
        NLS.initializeMessages(BUNDLE_NAME, Messages.class);
    }

    private Messages() {
    }
}
