/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import static org.eclipse.epp.internal.logging.aeri.ide.utils.IDEConstants.NOTIFY_CONFIGURATION;
import static org.eclipse.epp.logging.aeri.core.SystemControl.executeHandler;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenSystemSetupWizardHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.SystemControl;

import com.google.common.collect.Lists;

public class SetupSystemNotification extends Notification {

    private IEclipseContext context;

    @Inject
    public SetupSystemNotification(IEventBroker broker, IEclipseContext context) {
        super(NOTIFY_CONFIGURATION, broker);
        this.context = context;
    }

    @Override
    public List<NotificationAction> getActions() {
        NotificationAction a1 = new NotificationAction(Messages.NOTIFICATION_ACTION_ENABLE) {

            @Override
            public void execute() {
                closeWithEvent(null, null);
                executeHandler(OpenSystemSetupWizardHandler.class, context);
            }

        };
        NotificationAction a2 = new NotificationAction(Messages.NOTIFICATION_ACTION_DISABLE) {

            @Override
            public void execute() {
                closeWithEvent(null, null);
                ISystemSettings settings = SystemControl.getSystemSettings();
                settings.setSendMode(SendMode.NEVER);
            }

        };
        return Lists.newArrayList(a1, a2);
    }

    @Override
    public String getTitle() {
        return Messages.NOTIFICATION_TITLE_SETUP_SYSTEM;
    }

    @Override
    public String getLabel() {
        return Messages.NOTIFICATION_LABEL_SETUP_SYSTEM;
    }

    @Override
    public String getDescription() {
        return Messages.NOTIFICATION_DESCRIPTION_SETUP_SYSTEM;
    }
}
