/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.swt.widgets.Shell;

public interface IEditableReportProcessor extends IReportProcessor {

    enum EditResult {
        MODIFIED, UNMODIFIED, CANCELED
    }

    /**
     * Open an edit dialog that let's the user edit the current data.
     *
     * @return <code>MODIFIED</code> if the data was changed, <code>UNMODIFIED</code> if no change was made, <code>CANCELED</code> if the
     *         edit was canceled.
     */
    EditResult edit(IStatus status, IEclipseContext context, Shell parent);

    /**
     * Reset the data to its initial, unedited form.
     */
    void reset(IStatus status, IEclipseContext context);
}
