/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;

import com.google.common.annotations.VisibleForTesting;

public abstract class PlatformDetailsSectionProcessor extends CachingStringProcessor implements IReportProcessor {

    public String sectionTitle;

    public PlatformDetailsSectionProcessor(IProcessorDescriptor descriptor, String sectionTitle) {
        super(descriptor);
        this.sectionTitle = sectionTitle;
    }

    @Override
    public boolean canContribute(IStatus status) {
        return !StringUtils.isEmpty(ConfigurationInfo.getConfiguration("Platform Details"));
    }

    @Override
    public final boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    @VisibleForTesting
    protected String doAnalyze() {
        String configuration = ConfigurationInfo.getConfiguration("Platform Details");
        int sectionStart = configuration.indexOf(sectionTitle);
        if (sectionStart == -1) {
            return "";
        }
        // omit the title
        sectionStart += sectionTitle.length();
        // end = begin of next section
        int sectionEnd = configuration.indexOf("*** ", sectionStart + 1) - 1;
        if (sectionEnd < 0) {
            // if no next section: end = next blank line
            sectionEnd = configuration.indexOf(System.lineSeparator() + System.lineSeparator(), sectionStart + 1) - 1;
            if (sectionEnd < 0) {
                // otherwise use everything left
                sectionEnd = configuration.length();
            }
        }
        return configuration.substring(sectionStart, sectionEnd);
    }

}
