/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SendModeLabelProvider;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenConfigureServersDialogHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage,
IModelPackage.Literals {
    private DataBindingContext context = new DataBindingContext();
    private ISystemSettings systemSettings = SystemControl.getSystemSettings();

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.PREFERENCE_PAGE_DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite personalGroup = this.createPersonalGroup(container);
        Group anonymizeDefaults = this.createAnonymizeControl(container);
        UI.gdGrabH().indent(0, 10).applyTo((Control)personalGroup);
        UI.gdGrabH().indent(0, 10).applyTo((Control)anonymizeDefaults);
        Composite sendModeDefaults = this.createSendModeControl(container);
        this.addConfigureButton(container);
        Button debug = UI.createCheckButton(container, Messages.FIELD_LABEL_ENABLE_DEBUG, Messages.TOOLTIP_ENABLE_DEBUG);
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)debug);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__DEBUG_ENABLED).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        this.addLinks(container);
        UI.gl().margins(5, 5).applyTo(container);
        UI.gd().applyTo((Control)container);
        UI.gd().applyTo((Control)sendModeDefaults);
        this.applyDialogFont(container);
        return container;
    }

    private Composite createSendModeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        Label label = new Label(container, 0);
        label.setText(Messages.LABEL_TEXT_SEND_MODE);
        label.setToolTipText(Messages.TOOLTIP_SEND_MODE);
        ComboViewer sendMode = new ComboViewer(container);
        sendMode.getControl().setToolTipText(Messages.TOOLTIP_SEND_MODE);
        sendMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        sendMode.setInput((Object)SendMode.VALUES);
        sendMode.setLabelProvider((IBaseLabelProvider)new SendModeLabelProvider());
        IViewerObservableValue jface = ViewersObservables.observeSinglePostSelection((StructuredViewer)sendMode);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)SYSTEM_SETTINGS__SEND_MODE).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)jface, emf, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        UI.gl().numColumns(2).applyTo(container);
        UI.gd().align(1, 0x1000000).applyTo((Control)label);
        UI.gdGrabH().align(0x1000008, 0x1000000).applyTo((Control)sendMode.getCombo());
        return container;
    }

    private Composite createPersonalGroup(Composite parent) {
        Group personalGroup = new Group(parent, 0);
        personalGroup.setText(Messages.GROUP_TEXT_CONTACT_INFORMATION);
        UI.gl().margins(5, 5).numColumns(2).applyTo((Composite)personalGroup);
        Text name = UI.createLabelWithText((Composite)personalGroup, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME, Messages.FIELD_MESSAGE_NAME);
        ISWTObservableValue swt = WidgetProperties.text((int)16).observe((Widget)name);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)USER_SETTINGS__REPORTER_NAME).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        String tooltip = String.valueOf(Messages.FIELD_MESSAGE_EMAIL) + '\n' + Messages.TOOLTIP_SETTINGS_EMAIL;
        Text email = UI.createLabelWithText((Composite)personalGroup, Messages.FIELD_LABEL_EMAIL, Messages.FIELD_MESSAGE_EMAIL, tooltip);
        ISWTObservableValue swt2 = WidgetProperties.text((int)24).observe((Widget)email);
        IObservableValue emf2 = EMFProperties.value((EStructuralFeature)USER_SETTINGS__REPORTER_EMAIL).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt2, emf2, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        return personalGroup;
    }

    private Group createAnonymizeControl(Composite parent) {
        Group container = new Group(parent, 92);
        container.setLayout((Layout)new RowLayout(512));
        container.setText(Messages.GROUP_TEXT_ANONYMIZATION);
        Button stackTraces = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_SETTINGS_MAKE_STACKTRACE_ANONYMOUS);
        stackTraces.setFocus();
        ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)stackTraces);
        IObservableValue emf = EMFProperties.value((EStructuralFeature)USER_SETTINGS__ANONYMIZE_STACK_TRACES).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        Button messages = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_SETTINGS_MAKE_MESSAGES_ANONYMOUS);
        swt = WidgetProperties.selection().observe((Widget)messages);
        emf = EMFProperties.value((EStructuralFeature)USER_SETTINGS__ANONYMIZE_MESSAGES).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        Button disableWiringAnalysis = UI.createCheckButton((Composite)container, Messages.FIELD_LABEL_DISABLE_AUTOMATIC_WIRING_ANALYSIS, Messages.TOOLTIP_DISABLE_AUTOMATIC_WIRING_ANALYSIS);
        swt = WidgetProperties.selection().observe((Widget)disableWiringAnalysis);
        emf = EMFProperties.value((EStructuralFeature)IModelPackage.Literals.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS).observe((Object)this.systemSettings);
        this.context.bindValue((IObservableValue)swt, emf, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
        return container;
    }

    private void addConfigureButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(Messages.BUTTON_TEXT_CONFIGURE_SERVERS);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemControl.executeHandler(OpenConfigureServersDialogHandler.class);
            }
        });
        UI.gd().align(0x1000008, 0x1000000).applyTo((Control)button);
    }

    private void addLinks(Composite parent) {
        Composite links = new Composite(parent, 0);
        links.setLayout((Layout)new RowLayout(512));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)links);
        this.createNotificationsLabelAndLink(links);
    }

    private void createNotificationsLabelAndLink(Composite links) {
        Link link = new Link(links, 0);
        link.setText(Messages.LINK_TEXT_NOTIFICATION_PREFERENCE_PAGE);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PreferencePage.this.getShell(), (String)"org.eclipse.mylyn.commons.notifications.preferencePages.Notifications", null, null);
            }
        });
    }

    private static String[][] createModeLabelAndValues() {
        SendMode[] modes = SendMode.values();
        String[][] labelAndValues = new String[modes.length][2];
        int i = 0;
        while (i < modes.length) {
            SendMode mode = modes[i];
            labelAndValues[i][0] = PreferencePage.descriptionForMode(mode);
            labelAndValues[i][1] = mode.name();
            ++i;
        }
        return labelAndValues;
    }

    private static String descriptionForMode(SendMode mode) {
        return new SendModeLabelProvider().getText(mode);
    }

    public boolean performOk() {
        this.context.updateModels();
        return super.performOk();
    }
}

