/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import com.google.common.base.Throwables;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ConfigureServerDialog;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CreateConfigureDialogHandler {
    @Execute
    public Dialog execute(IServerDescriptor server, IEclipseContext context) {
        IEclipseContext child = context.createChild("configure-scope-ctx");
        child.set(IServerDescriptor.class, (Object)server);
        String contributor = server.getContributor();
        String clazzName = this.getConfigureDialogClassName(server);
        Bundle ext = null;
        if (clazzName != null) {
            ext = Platform.getBundle((String)contributor);
        } else {
            clazzName = ConfigureServerDialog.class.getName();
            ext = FrameworkUtil.getBundle(this.getClass());
        }
        try {
            Class clazz = ext.loadClass(clazzName);
            Dialog object = (Dialog)ContextInjectionFactory.make((Class)clazz, (IEclipseContext)child);
            return object;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    private String getConfigureDialogClassName(IServerDescriptor server) {
        IConfigurationElement element = server.getConfigurationElement();
        Object[] children = element.getChildren("configure");
        if (ArrayUtils.isEmpty((Object[])children)) {
            return null;
        }
        return children[0].getAttribute("dialog");
    }
}

