/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.events;

import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.MouseEvent;
import org.eclipse.fx.ui.controls.styledtext.events.HoverTarget;

public class TextHoverEvent
extends MouseEvent {
    private static final long serialVersionUID = 1L;
    public static final EventType<TextHoverEvent> HOVER = new EventType(Event.ANY, "STYLED_TEXT_HOVER");
    private final int offsetTokenStart;
    private final int offsetTokenEnd;
    private final String tokenText;
    private final int offset;
    private final List<HoverTarget> hoverTargets;

    public TextHoverEvent(MouseEvent source, List<HoverTarget> hoverTargets) {
        super(HOVER, source.getSceneX(), source.getSceneY(), source.getScreenX(), source.getScreenY(), source.getButton(), source.getClickCount(), source.isShiftDown(), source.isControlDown(), source.isAltDown(), source.isMetaDown(), source.isPrimaryButtonDown(), source.isMiddleButtonDown(), source.isSecondaryButtonDown(), source.isSynthesized(), source.isPopupTrigger(), source.isStillSincePress(), source.getPickResult());
        this.hoverTargets = Collections.unmodifiableList(hoverTargets);
        Optional<Range> range = this.hoverTargets.stream().map(t -> t.textRange).findFirst();
        this.tokenText = null;
        this.offsetTokenStart = range.isPresent() ? (Integer)range.get().lowerEndpoint() : 0;
        this.offsetTokenEnd = range.isPresent() ? (Integer)range.get().upperEndpoint() : 0;
        this.offset = range.isPresent() ? (Integer)range.get().lowerEndpoint() : 0;
    }

    public List<HoverTarget> getHoverTargets() {
        return this.hoverTargets;
    }

    public TextHoverEvent(MouseEvent event, int offsetTokenStart, int offsetTokenEnd, int offset, String tokenText) {
        super(HOVER, event.getSceneX(), event.getSceneY(), event.getScreenX(), event.getScreenY(), event.getButton(), event.getClickCount(), event.isShiftDown(), event.isControlDown(), event.isAltDown(), event.isMetaDown(), event.isPrimaryButtonDown(), event.isMiddleButtonDown(), event.isSecondaryButtonDown(), event.isSynthesized(), event.isPopupTrigger(), event.isStillSincePress(), event.getPickResult());
        this.offsetTokenStart = offsetTokenStart;
        this.offsetTokenEnd = offsetTokenEnd;
        this.tokenText = tokenText;
        this.offset = offset;
        this.hoverTargets = null;
    }

    public int getOffsetTokenStart() {
        return this.offsetTokenStart;
    }

    public int getOffsetTokenEnd() {
        return this.offsetTokenEnd;
    }

    public String getTokenText() {
        return this.tokenText;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hoverTargets == null ? 0 : this.hoverTargets.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + this.offsetTokenEnd;
        result = 31 * result + this.offsetTokenStart;
        result = 31 * result + (this.tokenText == null ? 0 : this.tokenText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TextHoverEvent other = (TextHoverEvent)((Object)obj);
        if (this.hoverTargets == null ? other.hoverTargets != null : !this.hoverTargets.equals(other.hoverTargets)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.offsetTokenEnd != other.offsetTokenEnd) {
            return false;
        }
        if (this.offsetTokenStart != other.offsetTokenStart) {
            return false;
        }
        return !(this.tokenText == null ? other.tokenText != null : !this.tokenText.equals(other.tokenText));
    }
}

