/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.binding;

import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import org.eclipse.gef4.common.beans.value.ObservableMultisetValue;
import org.eclipse.gef4.common.collections.MultisetChangeListener;
import org.eclipse.gef4.common.collections.MultisetListenerHelper;
import org.eclipse.gef4.common.collections.ObservableMultiset;

public class MultisetExpressionHelper<E>
extends MultisetListenerHelper<E> {
    private List<ChangeListener<? super ObservableMultiset<E>>> changeListeners = null;
    private ObservableMultisetValue<E> observableValue = null;
    private ObservableMultiset<E> currentValue = null;
    private boolean lockChangeListeners;

    public MultisetExpressionHelper(ObservableMultisetValue<E> observableValue) {
        super(observableValue);
        this.observableValue = observableValue;
        this.currentValue = (ObservableMultiset)observableValue.getValue();
    }

    @Override
    public void addListener(ChangeListener<? super ObservableMultiset<E>> listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener<? super ObservableMultiset<E>>>();
        }
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableMultiset<ChangeListener<? super ObservableMultiset<E>>>>>(this.changeListeners);
        }
        this.changeListeners.add(listener);
    }

    public void fireValueChangedEvent() {
        ObservableMultiset<E> oldValue = this.currentValue;
        this.currentValue = (ObservableMultiset)this.observableValue.getValue();
        this.notifyListeners(oldValue, this.currentValue);
    }

    @Override
    public void fireValueChangedEvent(MultisetChangeListener.Change<? extends E> change) {
        if (change != null) {
            this.notifyInvalidationListeners();
            this.notifyMultisetChangeListeners(new MultisetListenerHelper.AtomicChange<E>(this.observableValue, change));
        }
    }

    private void notifyListeners(ObservableMultiset<E> oldValue, ObservableMultiset<E> currentValue) {
        if (currentValue != oldValue) {
            this.notifyInvalidationListeners();
            if (this.changeListeners != null) {
                try {
                    this.lockChangeListeners = true;
                    for (ChangeListener<? super ObservableMultiset<E>> changeListener : this.changeListeners) {
                        changeListener.changed(this.observableValue, oldValue, currentValue);
                    }
                }
                finally {
                    this.lockChangeListeners = false;
                }
            }
            if (oldValue == null || !oldValue.equals(currentValue)) {
                this.notifyMultisetListeners(oldValue, currentValue);
            }
        }
    }

    private void notifyMultisetListeners(ObservableMultiset<E> oldValue, ObservableMultiset<E> currentValue) {
        if (currentValue == null) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : oldValue.elementSet()) {
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, oldValue.count(e), 0));
            }
            this.notifyMultisetChangeListeners(new MultisetListenerHelper.AtomicChange(this.getSource(), HashMultiset.create(oldValue), elementaryChanges));
        } else if (oldValue == null) {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : currentValue.elementSet()) {
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, 0, currentValue.count(e)));
            }
            this.notifyMultisetChangeListeners(new MultisetListenerHelper.AtomicChange(this.getSource(), HashMultiset.create(), elementaryChanges));
        } else {
            ArrayList elementaryChanges = new ArrayList();
            for (Object e : oldValue.elementSet()) {
                if (currentValue.contains(e)) {
                    if (oldValue.count(e) > currentValue.count(e)) {
                        elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, oldValue.count(e) - currentValue.count(e), 0));
                        continue;
                    }
                    if (currentValue.count(e) <= oldValue.count(e)) continue;
                    elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, 0, currentValue.count(e) - oldValue.count(e)));
                    continue;
                }
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, oldValue.count(e), 0));
            }
            for (Object e : currentValue.elementSet()) {
                if (oldValue.contains(e)) continue;
                elementaryChanges.add(new MultisetListenerHelper.ElementarySubChange(e, 0, currentValue.count(e)));
            }
            this.notifyMultisetChangeListeners(new MultisetListenerHelper.AtomicChange(this.getSource(), HashMultiset.create(oldValue), elementaryChanges));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableMultiset<E>> listener) {
        if (this.lockChangeListeners) {
            this.changeListeners = new ArrayList<ChangeListener<ObservableMultiset<ChangeListener<? super ObservableMultiset<E>>>>>(this.changeListeners);
        }
        Iterator<ChangeListener<ObservableMultiset<E>>> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }
}

