/*******************************************************************************
 * Copyright (c) 2016 itemis AG and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Alexander Nyßen (itemis AG) - initial API and implementation
 *     Tamas Miklossy  (itemis AG) - implement additional validation checks (bug #477980)
 *
 *******************************************************************************/

/*
 * generated by Xtext
 */
package org.eclipse.gef4.dot.internal.parser.validation;

import org.eclipse.gef4.dot.internal.parser.arrowtype.AbstractArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowType;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowtypePackage;
import org.eclipse.gef4.dot.internal.parser.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.PrimitiveShape;
import org.eclipse.xtext.validation.Check;

/**
 * This class contains custom validation rules.
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#
 * validation
 */
public class DotArrowTypeJavaValidator extends
		org.eclipse.gef4.dot.internal.parser.validation.AbstractDotArrowTypeJavaValidator {

	/**
	 * Checks that the open modifier is not used in combination with illegal
	 * primitive shapes.
	 * 
	 * @param arrowShape
	 *            The arrowShape element to check.
	 */
	@Check
	public void checkOpenModifier(ArrowShape arrowShape) {
		PrimitiveShape shape = arrowShape.getShape();
		if (arrowShape.isOpen() && (PrimitiveShape.CROW.equals(shape)
				|| PrimitiveShape.CURVE.equals(shape)
				|| PrimitiveShape.ICURVE.equals(shape)
				|| PrimitiveShape.NONE.equals(shape)
				|| PrimitiveShape.TEE.equals(shape)
				|| PrimitiveShape.VEE.equals(shape))) {
			warning("The open modifier 'o' may not be combined with primitive shape '"
					+ shape + "'.",
					ArrowtypePackage.Literals.ARROW_SHAPE__OPEN);
		}
	}

	/**
	 * Checks that the side modifier is not used in combination with illegal
	 * primitive shapes.
	 * 
	 * @param arrowShape
	 *            The arrowShape element to check.
	 */
	@Check
	public void checkSideModifier(ArrowShape arrowShape) {
		PrimitiveShape shape = arrowShape.getShape();
		if (arrowShape.getSide() != null && (PrimitiveShape.DOT.equals(shape)
				|| PrimitiveShape.NONE.equals(shape))) {
			warning("The side modifier '" + arrowShape.getSide()
					+ "' may not be combined with primitive shape '" + shape
					+ "'.", ArrowtypePackage.Literals.ARROW_SHAPE__SIDE);
		}
	}

	/**
	 * Checks that no deprecated arrow shapes are used
	 * 
	 * @param arrowShape
	 *            The arrowShape element to check.
	 */
	@Check
	public void checkDeprecatedArrowShape(DeprecatedArrowShape arrowShape) {
		warning("The shape '" + arrowShape.getShape() + "' is deprecated.",
				ArrowtypePackage.Literals.DEPRECATED_ARROW_SHAPE__SHAPE);
	}

	/**
	 * Checks whether none is the last arrow shape, since this would create a
	 * redundant shape
	 * 
	 * @param arrowType
	 *            The arrowType element to check.
	 */
	@Check
	public void checkIfNoneIsTheLastArrowShape(ArrowType arrowType) {
		int numberOfArrowShapes = arrowType.getArrowShapes().size();
		if (numberOfArrowShapes > 1) {
			AbstractArrowShape lastShape = arrowType.getArrowShapes()
					.get(numberOfArrowShapes - 1);
			if (lastShape instanceof ArrowShape && ((ArrowShape) lastShape)
					.getShape() == PrimitiveShape.NONE) {
				warning("The shape '" + PrimitiveShape.NONE
						+ "' may not be the last shape.",
						ArrowtypePackage.Literals.ARROW_SHAPE__SHAPE);
			}
		}
	}
}
