/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.gestures;

import javafx.event.EventHandler;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef4.fx.gestures.AbstractGesture;

public abstract class AbstractPinchSpreadGesture
extends AbstractGesture {
    private boolean inZoom = false;
    private EventHandler<? super ZoomEvent> zoomFilter = new EventHandler<ZoomEvent>(){

        public void handle(ZoomEvent event) {
            if (!event.isInertia()) {
                if (event.getEventType() == ZoomEvent.ZOOM_STARTED) {
                    if (!AbstractPinchSpreadGesture.this.inZoom) {
                        AbstractPinchSpreadGesture.this.inZoom = true;
                        AbstractPinchSpreadGesture.this.zoomStarted(event);
                    }
                } else if (event.getEventType() == ZoomEvent.ZOOM) {
                    AbstractPinchSpreadGesture.this.zoom(event);
                } else if (event.getEventType() == ZoomEvent.ZOOM_FINISHED) {
                    AbstractPinchSpreadGesture.this.zoomFinished(event);
                    AbstractPinchSpreadGesture.this.inZoom = false;
                }
            }
        }
    };

    @Override
    protected void register() {
        this.getScene().addEventFilter(ZoomEvent.ZOOM_FINISHED, this.zoomFilter);
        this.getScene().addEventFilter(ZoomEvent.ZOOM_STARTED, this.zoomFilter);
        this.getScene().addEventFilter(ZoomEvent.ZOOM, this.zoomFilter);
    }

    @Override
    protected void unregister() {
        this.getScene().removeEventFilter(ZoomEvent.ZOOM_STARTED, this.zoomFilter);
        this.getScene().removeEventFilter(ZoomEvent.ZOOM_FINISHED, this.zoomFilter);
        this.getScene().removeEventFilter(ZoomEvent.ZOOM, this.zoomFilter);
    }

    protected abstract void zoom(ZoomEvent var1);

    protected abstract void zoomFinished(ZoomEvent var1);

    protected abstract void zoomStarted(ZoomEvent var1);
}

