/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.swt;

import java.awt.geom.PathIterator;
import org.eclipse.swt.graphics.PathData;

public class AWT2SWT {
    private static float[] getPointAppended(float[] points, float x, float y) {
        float[] pointsTmp = new float[points.length + 2];
        System.arraycopy(points, 0, pointsTmp, 0, points.length);
        pointsTmp[points.length] = x;
        pointsTmp[points.length + 1] = y;
        return pointsTmp;
    }

    private static byte[] getTypeAppended(byte[] types, byte type) {
        byte[] typesTmp = new byte[types.length + 1];
        System.arraycopy(types, 0, typesTmp, 0, types.length);
        typesTmp[types.length] = type;
        return typesTmp;
    }

    public static PathData toSWTPathData(PathIterator iterator) {
        byte[] types = new byte[]{};
        float[] points = new float[]{};
        while (!iterator.isDone()) {
            float[] segment = new float[6];
            int type = iterator.currentSegment(segment);
            switch (type) {
                case 0: {
                    types = AWT2SWT.getTypeAppended(types, (byte)1);
                    points = AWT2SWT.getPointAppended(points, segment[0], segment[1]);
                    break;
                }
                case 1: {
                    types = AWT2SWT.getTypeAppended(types, (byte)2);
                    points = AWT2SWT.getPointAppended(points, segment[0], segment[1]);
                    break;
                }
                case 2: {
                    types = AWT2SWT.getTypeAppended(types, (byte)3);
                    points = AWT2SWT.getPointAppended(points, segment[0], segment[1]);
                    points = AWT2SWT.getPointAppended(points, segment[2], segment[3]);
                    break;
                }
                case 3: {
                    types = AWT2SWT.getTypeAppended(types, (byte)4);
                    points = AWT2SWT.getPointAppended(points, segment[0], segment[1]);
                    points = AWT2SWT.getPointAppended(points, segment[2], segment[3]);
                    points = AWT2SWT.getPointAppended(points, segment[4], segment[5]);
                    break;
                }
                case 4: {
                    types = AWT2SWT.getTypeAppended(types, (byte)5);
                }
            }
            iterator.next();
        }
        PathData pathData = new PathData();
        pathData.points = points;
        pathData.types = types;
        return pathData;
    }

    private AWT2SWT() {
    }
}

