/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.ShapeUtils;

public class CurvedPolygon
extends AbstractGeometry
implements IShape,
ITranslatable<CurvedPolygon>,
IRotatable<CurvedPolygon>,
IScalable<CurvedPolygon> {
    private static final long serialVersionUID = 1L;
    private BezierCurve[] edges;

    public CurvedPolygon(BezierCurve ... curvedSides) {
        this.edges = new BezierCurve[curvedSides.length];
        int i = 0;
        while (i < this.edges.length) {
            BezierCurve c = curvedSides[i];
            if (i == this.edges.length - 1) {
                if (!c.getP2().equals(this.edges[0].getP1())) {
                    throw new IllegalArgumentException("The last passed-in BezierCurve is not a closing segment. new CurvedPolygon(" + Arrays.asList(curvedSides) + ")");
                }
            } else if (!c.getP2().equals(curvedSides[i + 1].getP1())) {
                throw new IllegalArgumentException("Subsequent BezierCurves used to construct a CurvedPolygon need to be connected with each other. The " + i + "th and " + (i + 1) + "th passed-in BezierCurves violate this condition. new CurvedPolygon(" + Arrays.asList(curvedSides) + ")");
            }
            this.edges[i] = c.getCopy();
            this.edges[i].setP2(curvedSides[i == this.edges.length - 1 ? 0 : i + 1].getP1());
            ++i;
        }
    }

    public CurvedPolygon(List<BezierCurve> curvedSides) {
        this(curvedSides.toArray(new BezierCurve[0]));
    }

    private int computeLineWindingNumber(BezierCurve seg, Point p) {
        double sx = seg.getX1();
        double ex = seg.getX2();
        if (sx < p.x && ex < p.x) {
            return 0;
        }
        double sy = seg.getY1();
        double ey = seg.getY2();
        if (sy < p.y && ey < p.y) {
            return 0;
        }
        if (sy > p.y && ey > p.y) {
            return 0;
        }
        if (sx == ex) {
            return ey >= sy ? 1 : -1;
        }
        if (sy == ey) {
            return 0;
        }
        double m = (ey - sy) / (ex - sx);
        double xi = (p.y - sy + m * sx) / m;
        if (p.x > xi) {
            return 0;
        }
        return ey >= sy ? 1 : -1;
    }

    private int computeWindingNumber(BezierCurve seg, Point p) {
        if (this.isLinear(seg)) {
            int lineWindingNumber = this.computeLineWindingNumber(seg, p);
            return lineWindingNumber;
        }
        if (this.isLeftOfP(seg, p) || this.isAboveP(seg, p) || this.isBelowP(seg, p)) {
            return 0;
        }
        if (this.isRightEqualP(seg, p)) {
            if (p.y >= seg.getY1() && p.y < seg.getY2()) {
                return 1;
            }
            if (p.y < seg.getY1() && p.y >= seg.getY2()) {
                return -1;
            }
            return 0;
        }
        BezierCurve[] split = seg.split(0.5);
        return this.computeWindingNumber(split[0], p) + this.computeWindingNumber(split[1], p);
    }

    @Override
    public boolean contains(IGeometry g) {
        return ShapeUtils.contains((IShape)this, g);
    }

    @Override
    public boolean contains(Point p) {
        if (this.edges.length == 0) {
            return false;
        }
        if (this.edges.length == 1) {
            return this.edges[0].contains(p);
        }
        int w = 0;
        BezierCurve[] bezierCurveArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve seg = bezierCurveArray[n2];
            if (seg.contains(p)) {
                return true;
            }
            w += this.computeWindingNumber(seg, p);
            ++n2;
        }
        return w != 0;
    }

    @Override
    public Rectangle getBounds() {
        if (this.edges == null || this.edges.length == 0) {
            return new Rectangle();
        }
        Rectangle bounds = this.edges[0].getBounds();
        int i = 1;
        while (i < this.edges.length) {
            bounds.union(this.edges[i].getBounds());
            ++i;
        }
        return bounds;
    }

    public Point getCenter() {
        Point[] edgeCenters = new Point[this.edges.length];
        int i = 0;
        while (i < this.edges.length) {
            edgeCenters[i] = Point.getCentroid(this.edges[i].getPoints());
            ++i;
        }
        return Point.getCentroid(edgeCenters);
    }

    @Override
    public CurvedPolygon getCopy() {
        return new CurvedPolygon(this.edges);
    }

    @Override
    public PolyBezier getOutline() {
        return new PolyBezier(this.edges);
    }

    public BezierCurve[] getOutlineSegments() {
        return CurveUtils.getCopy(this.edges);
    }

    @Override
    public CurvedPolygon getRotatedCCW(Angle angle) {
        Point c = this.getCenter();
        return this.getRotatedCCW(angle, c.x, c.y);
    }

    @Override
    public CurvedPolygon getRotatedCCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCCW(angle, cx, cy);
    }

    @Override
    public CurvedPolygon getRotatedCCW(Angle angle, Point center) {
        return this.getRotatedCCW(angle, center.x, center.y);
    }

    @Override
    public CurvedPolygon getRotatedCW(Angle angle) {
        Point c = this.getCenter();
        return this.getRotatedCW(angle, c.x, c.y);
    }

    @Override
    public CurvedPolygon getRotatedCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCW(angle, cx, cy);
    }

    @Override
    public CurvedPolygon getRotatedCW(Angle angle, Point center) {
        return this.getRotatedCW(angle, center.x, center.y);
    }

    @Override
    public CurvedPolygon getScaled(double factor) {
        Point c = this.getCenter();
        return this.getScaled(factor, factor, c.x, c.y);
    }

    @Override
    public CurvedPolygon getScaled(double fx, double fy) {
        Point c = this.getCenter();
        return this.getScaled(fx, fy, c.x, c.y);
    }

    @Override
    public CurvedPolygon getScaled(double factor, double cx, double cy) {
        return this.getScaled(factor, factor, cx, cy);
    }

    @Override
    public CurvedPolygon getScaled(double fx, double fy, double cx, double cy) {
        return this.getCopy().scale(fx, fy, cx, cy);
    }

    @Override
    public CurvedPolygon getScaled(double fx, double fy, Point center) {
        return this.getScaled(fx, fy, center.x, center.y);
    }

    @Override
    public CurvedPolygon getScaled(double factor, Point center) {
        return this.getScaled(factor, factor, center.x, center.y);
    }

    @Override
    public CurvedPolygon getTransformed(AffineTransform t) {
        BezierCurve[] transformed = new BezierCurve[this.edges.length];
        int i = 0;
        while (i < this.edges.length) {
            transformed[i] = this.edges[i].getTransformed(t);
            ++i;
        }
        return new CurvedPolygon(transformed);
    }

    @Override
    public CurvedPolygon getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    @Override
    public CurvedPolygon getTranslated(Point d) {
        return this.getTranslated(d.x, d.y);
    }

    private boolean isAboveP(BezierCurve seg, Point p) {
        Point[] pointArray = seg.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point cp = pointArray[n2];
            if (cp.y >= p.y) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isBelowP(BezierCurve seg, Point p) {
        Point[] pointArray = seg.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point cp = pointArray[n2];
            if (cp.y <= p.y) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isLeftOfP(BezierCurve seg, Point p) {
        Point[] pointArray = seg.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point cp = pointArray[n2];
            if (cp.x >= p.x) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isLinear(BezierCurve seg) {
        double d0 = seg.getP1().getDistance(seg.getP2());
        double d1 = 0.0;
        Point[] points = seg.getPoints();
        int i = 0;
        while (i < points.length - 1) {
            d1 += points[i].getDistance(points[i + 1]);
            ++i;
        }
        return PrecisionUtils.greaterEqual(d0, d1);
    }

    private boolean isRightEqualP(BezierCurve seg, Point p) {
        Point[] pointArray = seg.getPoints();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point cp = pointArray[n2];
            if (cp.x < p.x) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public CurvedPolygon rotateCCW(Angle angle) {
        Point c = this.getCenter();
        return this.rotateCCW(angle, c.x, c.y);
    }

    public CurvedPolygon rotateCCW(Angle angle, double cx, double cy) {
        BezierCurve[] bezierCurveArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.rotateCCW(angle, cx, cy);
            ++n2;
        }
        return this;
    }

    public CurvedPolygon rotateCCW(Angle angle, Point center) {
        return this.rotateCCW(angle, center.x, center.y);
    }

    public CurvedPolygon rotateCW(Angle angle) {
        Point c = this.getCenter();
        return this.rotateCW(angle, c.x, c.y);
    }

    public CurvedPolygon rotateCW(Angle angle, double cx, double cy) {
        BezierCurve[] bezierCurveArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.rotateCW(angle, cx, cy);
            ++n2;
        }
        return this;
    }

    public CurvedPolygon rotateCW(Angle angle, Point center) {
        return this.rotateCW(angle, center.x, center.y);
    }

    @Override
    public CurvedPolygon scale(double factor) {
        Point c = this.getCenter();
        return this.scale(factor, factor, c.x, c.y);
    }

    @Override
    public CurvedPolygon scale(double fx, double fy) {
        Point c = this.getCenter();
        return this.scale(fx, fx, c.x, c.y);
    }

    @Override
    public CurvedPolygon scale(double factor, double cx, double cy) {
        return this.scale(factor, factor, cx, cy);
    }

    @Override
    public CurvedPolygon scale(double fx, double fy, double cx, double cy) {
        BezierCurve[] bezierCurveArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.scale(fx, fy, cx, cy);
            ++n2;
        }
        return this;
    }

    @Override
    public CurvedPolygon scale(double fx, double fy, Point center) {
        return this.scale(fx, fx, center.x, center.y);
    }

    @Override
    public CurvedPolygon scale(double factor, Point center) {
        return this.scale(factor, factor, center.x, center.y);
    }

    @Override
    public Path toPath() {
        return CurveUtils.toPath(this.edges);
    }

    public String toString() {
        String s = "CurvedPolygon(";
        int i = 0;
        while (i < this.edges.length) {
            s = i == this.edges.length - 1 ? String.valueOf(s) + this.edges[i] : String.valueOf(s) + this.edges[i] + " -> ";
            ++i;
        }
        return String.valueOf(s) + ")";
    }

    @Override
    public CurvedPolygon translate(double dx, double dy) {
        BezierCurve[] bezierCurveArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.translate(dx, dy);
            ++n2;
        }
        return this;
    }

    @Override
    public CurvedPolygon translate(Point d) {
        return this.translate(d.x, d.y);
    }
}

