/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.LayoutContext;
import org.eclipse.gef4.layout.LayoutProperties;

public class HorizontalShiftAlgorithm
implements ILayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 16.0;
    private LayoutContext context;

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        ArrayList<List<Node>> rowsList = new ArrayList<List<Node>>();
        Node[] entities = this.context.getNodes();
        int i = 0;
        while (i < entities.length) {
            this.addToRowList(entities[i], rowsList);
            ++i;
        }
        Collections.sort(rowsList, new Comparator<List<Node>>(){

            @Override
            public int compare(List<Node> o1, List<Node> o2) {
                Node entity0 = o1.get(0);
                Node entity1 = o2.get(0);
                return (int)(LayoutProperties.getLocation((Node)entity0).y - LayoutProperties.getLocation((Node)entity1).y);
            }
        });
        Comparator<Node> entityComparator = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return (int)(LayoutProperties.getLocation((Node)o1).y - LayoutProperties.getLocation((Node)o2).y);
            }
        };
        Rectangle bounds = LayoutProperties.getBounds(this.context.getGraph());
        int heightSoFar = 0;
        for (List<Node> currentRow : rowsList) {
            Collections.sort(currentRow, entityComparator);
            int i2 = 0;
            int width = (int)(bounds.getWidth() / 2.0 - (double)(currentRow.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (LayoutProperties.getSize((Node)currentRow.get((int)0)).height + 16.0));
            for (Node entity : currentRow) {
                Dimension size = LayoutProperties.getSize(entity);
                LayoutProperties.setLocation(entity, new Point((double)(width + 10 * ++i2) + size.width / 2.0, (double)heightSoFar + size.height / 2.0));
                width = (int)((double)width + size.width);
            }
        }
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.context;
    }

    private void addToRowList(Node entity, ArrayList<List<Node>> rowsList) {
        double layoutY = LayoutProperties.getLocation((Node)entity).y;
        for (List<Node> currentRow : rowsList) {
            Node currentRowEntity = currentRow.get(0);
            double currentRowY = LayoutProperties.getLocation((Node)currentRowEntity).y;
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(entity);
            return;
        }
        ArrayList<Node> newRow = new ArrayList<Node>();
        newRow.add(entity);
        rowsList.add(newRow);
    }
}

