/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.behaviors;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXFocusBehavior
extends AbstractBehavior<Node> {
    public static final String FOCUS_FEEDBACK_PART_FACTORY = "FOCUS_FEEDBACK_PART_FACTORY";
    private IContentPart<Node, ? extends Node> focusPart;
    private boolean isViewerFocused;
    private ChangeListener<IContentPart<Node, ? extends Node>> focusObserver = new ChangeListener<IContentPart<Node, ? extends Node>>(){

        public void changed(ObservableValue<? extends IContentPart<Node, ? extends Node>> observable, IContentPart<Node, ? extends Node> oldValue, IContentPart<Node, ? extends Node> newValue) {
            FXFocusBehavior.this.focusPart = newValue;
            FXFocusBehavior.this.applyFocusToVisual();
            FXFocusBehavior.this.refreshFocusFeedback();
        }
    };
    private FocusModel<Node> focusModel;
    private ChangeListener<? super Boolean> viewerFocusedListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            FXFocusBehavior.this.isViewerFocused = newValue;
            FXFocusBehavior.this.refreshFocusFeedback();
        }
    };
    private IViewer<Node> viewer;
    private boolean hasViewerFocusedFeedback;

    protected void addViewerFocusedFeedback() {
        if (this.viewer instanceof FXViewer) {
            ((FXViewer)this.viewer).getCanvas().setStyle("-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(0,0,0,0); -fx-border-color: #8ec0fc; -fx-border-width: 2;");
        }
        this.hasViewerFocusedFeedback = true;
    }

    protected void applyFocusToVisual() {
        if (this.focusPart == null) {
            ((Node)this.viewer.getRootPart().getVisual()).requestFocus();
        } else {
            ((Node)this.focusPart.getVisual()).requestFocus();
        }
    }

    protected void doActivate() {
        super.doActivate();
        this.viewer = this.getHost().getRoot().getViewer();
        this.focusModel = (FocusModel)this.viewer.getAdapter((TypeToken)new TypeToken<FocusModel<Node>>(){});
        if (this.focusModel == null) {
            throw new IllegalStateException("Cannot obtain FocusModel<Node> from the IViewer of the host of this FXFocusBehavior.");
        }
        this.viewer.viewerFocusedProperty().addListener(this.viewerFocusedListener);
        this.focusModel.focusProperty().addListener(this.focusObserver);
        this.focusPart = this.focusModel.getFocus();
        this.isViewerFocused = this.viewer.isViewerFocused();
        this.refreshFocusFeedback();
    }

    protected void doDeactivate() {
        this.focusModel.focusProperty().removeListener(this.focusObserver);
        this.viewer.viewerFocusedProperty().removeListener(this.viewerFocusedListener);
        this.focusPart = null;
        this.isViewerFocused = false;
        this.refreshFocusFeedback();
        super.doDeactivate();
    }

    protected IFeedbackPartFactory<Node> getFeedbackPartFactory() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        return (IFeedbackPartFactory)viewer.getAdapter(AdapterKey.get((TypeToken)new TypeToken<IFeedbackPartFactory<Node>>(){}, (String)FOCUS_FEEDBACK_PART_FACTORY));
    }

    protected FocusModel<Node> getFocusModel() {
        return this.focusModel;
    }

    protected void refreshFocusFeedback() {
        if (this.getHost() == this.viewer.getRootPart()) {
            boolean showFeedback;
            boolean bl = showFeedback = this.isViewerFocused && this.focusPart == null;
            if (this.hasViewerFocusedFeedback && !showFeedback) {
                this.removeViewerFocusedFeedback();
            } else if (!this.hasViewerFocusedFeedback && showFeedback) {
                this.addViewerFocusedFeedback();
            }
        } else {
            boolean isFocused;
            List<IVisualPart> targets = Collections.singletonList(this.getHost());
            boolean hasFeedback = this.getFeedbackParts() != null && !this.getFeedbackParts().isEmpty();
            boolean bl = isFocused = this.isViewerFocused && this.getHost() == this.focusPart;
            if (hasFeedback && !isFocused) {
                this.removeFeedback(targets);
            } else if (!hasFeedback && isFocused) {
                List feedbackParts = this.getFeedbackPartFactory().createFeedbackParts(targets, (IBehavior)this, Collections.emptyMap());
                this.addFeedback(targets, feedbackParts);
            }
        }
    }

    protected void removeViewerFocusedFeedback() {
        if (this.viewer instanceof FXViewer) {
            ((FXViewer)this.viewer).getCanvas().setStyle("-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(0,0,0,0);");
        }
        this.hasViewerFocusedFeedback = false;
    }
}

