/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;

public class FXResizeOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final Node visual;
    private final Dimension initialSize;
    private double dw;
    private double dh;

    public FXResizeOperation(Node visual) {
        this(visual, 0.0, 0.0);
    }

    public FXResizeOperation(Node visual, double dw, double dh) {
        this("Resize", visual, new Dimension(visual.getLayoutBounds().getWidth(), visual.getLayoutBounds().getHeight()), dw, dh);
    }

    public FXResizeOperation(String label, Node visual, Dimension initialSize, double dw, double dh) {
        super(label);
        this.visual = visual;
        if (initialSize.width + dw < 0.0) {
            throw new IllegalArgumentException("Cannot resize below zero.");
        }
        if (initialSize.height + dh < 0.0) {
            throw new IllegalArgumentException("Cannot resize below zero.");
        }
        this.initialSize = initialSize.getCopy();
        this.dw = dw;
        this.dh = dh;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.visual.resize(this.initialSize.getWidth() + this.dw, this.initialSize.getHeight() + this.dh);
        return Status.OK_STATUS;
    }

    public double getDh() {
        return this.dh;
    }

    public double getDw() {
        return this.dw;
    }

    public Dimension getInitialSize() {
        return this.initialSize;
    }

    public Node getVisual() {
        return this.visual;
    }

    public boolean isContentRelevant() {
        return false;
    }

    public boolean isNoOp() {
        return this.dw == 0.0 && this.dh == 0.0;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setDh(double dh) {
        this.dh = dh;
    }

    public void setDw(double dw) {
        this.dw = dw;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.visual.resize(this.initialSize.getWidth(), this.initialSize.getHeight());
        return Status.OK_STATUS;
    }
}

