/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnRotatePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class FXRotateSelectedOnRotatePolicy
extends AbstractFXInteractionPolicy
implements IFXOnRotatePolicy {
    private Point pivotInScene;
    private Map<IContentPart<Node, ? extends Node>, Integer> rotationIndices = new HashMap<IContentPart<Node, ? extends Node>, Integer>();
    private List<IContentPart<Node, ? extends Node>> targetParts;
    private boolean invalidGesture = false;

    protected List<IContentPart<Node, ? extends Node>> determineTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
    }

    protected List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return this.targetParts;
    }

    protected FXTransformPolicy getTransformPolicy(IVisualPart<Node, ? extends Node> part) {
        return (FXTransformPolicy)((Object)part.getAdapter(FXTransformPolicy.class));
    }

    protected boolean isRotate(RotateEvent event) {
        return true;
    }

    @Override
    public void rotate(RotateEvent e) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
        }
    }

    @Override
    public void rotationAborted() {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.rollback((AbstractTransactionPolicy)transformPolicy);
        }
    }

    @Override
    public void rotationFinished(RotateEvent e) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
            FXTransformPolicy transformPolicy = this.getTransformPolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.commit((AbstractTransactionPolicy)transformPolicy);
        }
    }

    @Override
    public void rotationStarted(RotateEvent e) {
        this.targetParts = this.determineTargetParts();
        boolean bl = this.invalidGesture = !this.isRotate(e);
        if (this.invalidGesture) {
            return;
        }
        Rectangle bounds = FXPartUtils.getUnionedVisualBoundsInScene(this.targetParts);
        if (bounds == null) {
            throw new IllegalStateException("Cannot determine visual bounds (null).");
        }
        this.pivotInScene = bounds.getCenter();
        this.rotationIndices.clear();
        for (IContentPart<Node, ? extends Node> part : this.getTargetParts()) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy((IVisualPart<Node, ? extends Node>)part);
            if (transformPolicy == null) continue;
            this.storeAndDisableRefreshVisuals((IVisualPart)part);
            this.init((AbstractTransactionPolicy)transformPolicy);
            Point pivotInLocal = FX2Geometry.toPoint((Point2D)((Node)this.getHost().getVisual()).getParent().sceneToLocal(this.pivotInScene.x, this.pivotInScene.y));
            int translateIndex = transformPolicy.createPostTransform();
            int rotateIndex = transformPolicy.createPostTransform();
            int translateBackIndex = transformPolicy.createPostTransform();
            transformPolicy.setPostTranslate(translateIndex, -pivotInLocal.x, -pivotInLocal.y);
            transformPolicy.setPostTranslate(translateBackIndex, pivotInLocal.x, pivotInLocal.y);
            this.rotationIndices.put(part, rotateIndex);
        }
    }

    private void updateOperation(RotateEvent e, IVisualPart<Node, ? extends Node> part) {
        Angle rotationAngle = Angle.fromDeg((double)e.getTotalAngle());
        FXTransformPolicy transformPolicy = this.getTransformPolicy(part);
        if (transformPolicy != null) {
            transformPolicy.setPostRotate(this.rotationIndices.get(part), rotationAngle);
        }
    }
}

