/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnTypePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ChangeSelectionOperation;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXSelectFocusedOnTypePolicy
extends AbstractFXInteractionPolicy
implements IFXOnTypePolicy {
    protected boolean isSelect(KeyEvent event) {
        return KeyCode.SPACE.equals((Object)event.getCode());
    }

    @Override
    public void pressed(KeyEvent event) {
        if (this.isRegistered(event.getTarget()) && !this.isRegisteredForHost(event.getTarget())) {
            return;
        }
        if (!this.isSelect(event)) {
            return;
        }
        IVisualPart host = this.getHost();
        IViewer viewer = host.getRoot().getViewer();
        SelectionModel selectionModel = (SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
        Object op = null;
        if (host instanceof IRootPart) {
            op = new DeselectOperation(viewer, (List)selectionModel.getSelectionUnmodifiable());
        } else if (host instanceof IContentPart) {
            IContentPart contentPart = (IContentPart)host;
            op = event.isControlDown() ? (selectionModel.isSelected(contentPart) ? new DeselectOperation(viewer, Collections.singletonList(contentPart)) : new SelectOperation(viewer, Collections.singletonList(contentPart))) : new ChangeSelectionOperation(viewer, Collections.singletonList(contentPart));
        }
        if (op != null) {
            try {
                viewer.getDomain().execute((ITransactionalOperation)op, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void released(KeyEvent event) {
    }

    @Override
    public void typed(KeyEvent event) {
    }

    @Override
    public void unfocus() {
    }
}

