/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.mvc.behaviors.BehaviorUtils;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public abstract class AbstractBehavior<VR>
implements IBehavior<VR> {
    private ReadOnlyObjectWrapper<IVisualPart<VR, ? extends VR>> hostProperty = new ReadOnlyObjectWrapper();
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private List<IHandlePart<VR, ? extends VR>> handleParts;
    private List<IFeedbackPart<VR, ? extends VR>> feedbackParts;

    public final void activate() {
        if (!this.acs.isActive()) {
            this.acs.activate();
            this.doActivate();
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IVisualPart<VR, ? extends VR>> adaptableProperty() {
        return this.hostProperty.getReadOnlyProperty();
    }

    protected void addFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets, List<? extends IFeedbackPart<VR, ? extends VR>> feedback) {
        if (targets != null && !targets.isEmpty()) {
            this.feedbackParts = new ArrayList<IFeedbackPart<VR, VR>>(feedback);
            BehaviorUtils.addAnchoreds(this.getHost().getRoot(), targets, this.feedbackParts);
        }
    }

    protected void addHandles(List<? extends IVisualPart<VR, ? extends VR>> targets, List<? extends IHandlePart<VR, ? extends VR>> handles) {
        if (handles != null && !handles.isEmpty()) {
            this.handleParts = new ArrayList<IHandlePart<VR, VR>>(handles);
            BehaviorUtils.addAnchoreds(this.getHost().getRoot(), targets, this.handleParts);
        }
    }

    public final void deactivate() {
        if (this.acs.isActive()) {
            this.doDeactivate();
            this.acs.deactivate();
        }
    }

    protected void doActivate() {
    }

    protected void doDeactivate() {
    }

    public IVisualPart<VR, ? extends VR> getAdaptable() {
        return this.getHost();
    }

    protected List<IFeedbackPart<VR, ? extends VR>> getFeedbackParts() {
        return this.feedbackParts;
    }

    protected List<IHandlePart<VR, ? extends VR>> getHandleParts() {
        return this.handleParts;
    }

    @Override
    public IVisualPart<VR, ? extends VR> getHost() {
        return (IVisualPart)this.hostProperty.get();
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    protected void removeFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        if (this.feedbackParts != null && !this.feedbackParts.isEmpty() && targets != null && !targets.isEmpty()) {
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), targets, this.feedbackParts);
            for (IFeedbackPart<VR, ? extends VR> iFeedbackPart : this.feedbackParts) {
                iFeedbackPart.dispose();
            }
            this.feedbackParts.clear();
        }
    }

    protected void removeHandles(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        if (this.handleParts != null && !this.handleParts.isEmpty() && targets != null && !targets.isEmpty()) {
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), targets, this.handleParts);
            for (IHandlePart<VR, ? extends VR> iHandlePart : this.handleParts) {
                iHandlePart.dispose();
            }
            this.handleParts.clear();
        }
    }

    public void setAdaptable(IVisualPart<VR, ? extends VR> adaptable) {
        this.hostProperty.set(adaptable);
    }

    @Deprecated
    protected void switchAdaptableScopes() {
    }

    protected IHandlePart<VR, ? extends VR> updateHandles(IVisualPart<VR, ? extends VR> target, List<? extends IHandlePart<VR, ? extends VR>> handles, Comparator<IHandlePart<VR, ? extends VR>> interactedWithComparator, IHandlePart<VR, ? extends VR> interactedWith) {
        IHandlePart replacementHandle = null;
        if (handles != null && !handles.isEmpty()) {
            Comparable comparable;
            int compareTo;
            ArrayList<Object> oldHandles;
            ArrayList<IHandlePart<VR, VR>> newHandles = new ArrayList<IHandlePart<VR, VR>>(handles);
            BehaviorUtils.addAnchoreds(this.getHost().getRoot(), Collections.singletonList(target), newHandles);
            if (interactedWithComparator != null) {
                double minDistance = -1.0;
                for (IHandlePart iHandlePart : newHandles) {
                    double distance = interactedWithComparator.compare(interactedWith, iHandlePart);
                    if (replacementHandle != null && !(distance < minDistance)) continue;
                    minDistance = distance;
                    replacementHandle = iHandlePart;
                }
                if (replacementHandle != null) {
                    newHandles.remove(replacementHandle);
                }
            }
            if (this.handleParts != null) {
                oldHandles = new ArrayList<IHandlePart<VR, VR>>(this.getHandleParts());
                Iterator it = oldHandles.iterator();
                while (it.hasNext()) {
                    IHandlePart oldHandle = (IHandlePart)it.next();
                    ObservableSetMultimap observableSetMultimap = oldHandle.getAnchoragesUnmodifiable();
                    if (observableSetMultimap.keySet().contains(target)) continue;
                    it.remove();
                }
                if (interactedWith != null) {
                    oldHandles.remove(interactedWith);
                }
                ArrayList<IHandlePart> toRemove = new ArrayList<IHandlePart>();
                it = oldHandles.iterator();
                while (it.hasNext()) {
                    IHandlePart iHandlePart = (IHandlePart)it.next();
                    boolean noLongerExists = true;
                    for (IHandlePart iHandlePart2 : newHandles) {
                        if (!(iHandlePart2 instanceof Comparable) || (compareTo = (comparable = (Comparable)((Object)iHandlePart)).compareTo(iHandlePart2)) != 0) continue;
                        noLongerExists = false;
                        break;
                    }
                    if (!noLongerExists) continue;
                    toRemove.add(iHandlePart);
                    it.remove();
                }
                BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), Collections.singletonList(target), toRemove);
                for (IHandlePart iHandlePart : toRemove) {
                    iHandlePart.dispose();
                }
                this.handleParts.removeAll(toRemove);
            } else {
                oldHandles = new ArrayList();
            }
            ArrayList<IHandlePart> alreadyExists = new ArrayList<IHandlePart>();
            Iterator it = newHandles.iterator();
            while (it.hasNext()) {
                IHandlePart iHandlePart = (IHandlePart)it.next();
                boolean existsAlready = false;
                for (IHandlePart iHandlePart3 : oldHandles) {
                    if (!(iHandlePart3 instanceof Comparable) || (compareTo = (comparable = (Comparable)((Object)iHandlePart3)).compareTo(iHandlePart)) != 0) continue;
                    existsAlready = true;
                    break;
                }
                if (!existsAlready) continue;
                alreadyExists.add(iHandlePart);
                it.remove();
            }
            if (replacementHandle != null) {
                alreadyExists.add(replacementHandle);
            }
            BehaviorUtils.removeAnchoreds(this.getHost().getRoot(), Collections.singletonList(target), alreadyExists);
            for (IHandlePart iHandlePart : alreadyExists) {
                iHandlePart.dispose();
            }
            if (this.handleParts == null) {
                this.handleParts = new ArrayList<IHandlePart<VR, VR>>(newHandles);
            } else {
                this.handleParts.addAll(newHandles);
            }
        }
        return replacementHandle;
    }
}

