/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.common.collections.SetMultimapChangeListener;
import org.eclipse.gef4.common.dispose.IDisposable;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.behaviors.ContentPartPool;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.models.HoverModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IContentPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class ContentBehavior<VR>
extends AbstractBehavior<VR>
implements IDisposable {
    private ListChangeListener<Object> contentModelObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> change) {
            HoverModel hoverModel;
            ContentBehavior.this.synchronizeContentChildren((List<Object>)change.getList());
            IViewer viewer = ContentBehavior.this.getHost().getRoot().getViewer();
            SelectionModel selectionModel = (SelectionModel)viewer.getAdapter(new TypeToken<SelectionModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())));
            if (selectionModel != null) {
                selectionModel.clearSelection();
            }
            if ((hoverModel = (HoverModel)viewer.getAdapter(new TypeToken<HoverModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())))) != null) {
                hoverModel.clearHover();
            }
        }
    };
    private ChangeListener<Object> contentObserver = new ChangeListener<Object>(){

        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            ContentBehavior.this.synchronizeContentChildren((List<Object>)ImmutableList.copyOf(((IContentPart)ContentBehavior.this.getHost()).getContentChildrenUnmodifiable()));
            ContentBehavior.this.synchronizeContentAnchorages((SetMultimap<Object, String>)ImmutableSetMultimap.copyOf(((IContentPart)ContentBehavior.this.getHost()).getContentAnchoragesUnmodifiable()));
        }
    };
    private ListChangeListener<Object> contentChildrenObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> change) {
            ContentBehavior.this.synchronizeContentChildren(new ArrayList(change.getList()));
        }
    };
    private SetMultimapChangeListener<Object, String> contentAnchoragesObserver = new SetMultimapChangeListener<Object, String>(){

        public void onChanged(SetMultimapChangeListener.Change<? extends Object, ? extends String> change) {
            ContentBehavior.this.synchronizeContentAnchorages((SetMultimap<Object, String>)HashMultimap.create((Multimap)change.getSetMultimap()));
        }
    };
    @Inject
    private ContentPartPool<VR> contentPartPool;

    public void dispose() {
        this.contentPartPool = null;
        this.contentObserver = null;
        this.contentModelObserver = null;
        this.contentChildrenObserver = null;
        this.contentAnchoragesObserver = null;
    }

    protected void disposeIfObsolete(IContentPart<VR, ? extends VR> contentPart) {
        if (contentPart.getParent() == null && contentPart.getAnchoredsUnmodifiable().isEmpty()) {
            this.contentPartPool.add(contentPart);
            contentPart.setContent(null);
        }
    }

    @Override
    protected void doActivate() {
        IVisualPart host = this.getHost();
        if (host == host.getRoot()) {
            ContentModel contentModel = this.getContentModel();
            contentModel.getContents().addListener(this.contentModelObserver);
            this.synchronizeContentChildren((List<? extends Object>)contentModel.getContents());
        } else {
            this.synchronizeContentChildren((List<Object>)ImmutableList.copyOf(((IContentPart)host).getContentChildrenUnmodifiable()));
            this.synchronizeContentAnchorages((SetMultimap<Object, String>)ImmutableSetMultimap.copyOf(((IContentPart)host).getContentAnchoragesUnmodifiable()));
            ((IContentPart)host).contentProperty().addListener(this.contentObserver);
            ((IContentPart)host).getContentChildrenUnmodifiable().addListener(this.contentChildrenObserver);
            ((IContentPart)host).getContentAnchoragesUnmodifiable().addListener(this.contentAnchoragesObserver);
        }
    }

    @Override
    protected void doDeactivate() {
        IVisualPart host = this.getHost();
        if (host == host.getRoot()) {
            this.getContentModel().getContents().removeListener(this.contentModelObserver);
        } else {
            ((IContentPart)host).contentProperty().removeListener(this.contentObserver);
            ((IContentPart)host).getContentChildrenUnmodifiable().removeListener(this.contentChildrenObserver);
            ((IContentPart)host).getContentAnchoragesUnmodifiable().removeListener(this.contentAnchoragesObserver);
        }
    }

    protected IContentPart<VR, ? extends VR> findOrCreatePartFor(Object content) {
        IContentPartFactory<VR> contentPartFactory;
        Map contentPartMap = this.getHost().getRoot().getViewer().getContentPartMap();
        if (contentPartMap.containsKey(content)) {
            return contentPartMap.get(content);
        }
        IContentPart<VR, VR> contentPart = null;
        contentPart = this.contentPartPool.remove(content);
        if (contentPart == null && (contentPart = (contentPartFactory = this.getContentPartFactory()).createContentPart(content, this, Collections.emptyMap())) == null) {
            throw new IllegalStateException("IContentPartFactory '" + contentPartFactory.getClass().getSimpleName() + "' did not create part for " + content + ".");
        }
        contentPart.setContent(content);
        return contentPart;
    }

    protected ContentModel getContentModel() {
        ContentModel contentModel = (ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class);
        return contentModel;
    }

    protected IContentPartFactory<VR> getContentPartFactory() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        IContentPartFactory cpFactory = (IContentPartFactory)viewer.getAdapter(new TypeToken<IContentPartFactory<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())));
        return cpFactory;
    }

    public void synchronizeContentAnchorages(SetMultimap<? extends Object, ? extends String> contentAnchorages) {
        if (contentAnchorages == null) {
            throw new IllegalArgumentException("contentAnchorages may not be null");
        }
        ObservableSetMultimap anchorages = this.getHost().getAnchoragesUnmodifiable();
        ArrayList<Map.Entry> toRemove = new ArrayList<Map.Entry>();
        Set entries = anchorages.entries();
        for (Map.Entry e : entries) {
            Object content;
            if (!(e.getKey() instanceof IContentPart) || contentAnchorages.containsEntry(content = ((IContentPart)e.getKey()).getContent(), e.getValue())) continue;
            toRemove.add(e);
        }
        for (Map.Entry e : toRemove) {
            this.getHost().detachFromAnchorage((IVisualPart)e.getKey(), (String)e.getValue());
            this.disposeIfObsolete((IContentPart)e.getKey());
        }
        ArrayList<Map.Entry> toAdd = new ArrayList<Map.Entry>();
        for (Map.Entry e : contentAnchorages.entries()) {
            IContentPart<VR, VR> anchorage = this.findOrCreatePartFor(e.getKey());
            if (anchorages.containsEntry(anchorage, e.getValue())) continue;
            toAdd.add(Maps.immutableEntry(anchorage, (Object)((String)e.getValue())));
        }
        for (Map.Entry e : toAdd) {
            this.getHost().attachToAnchorage((IVisualPart)e.getKey(), (String)e.getValue());
        }
    }

    public void synchronizeContentChildren(List<? extends Object> contentChildren) {
        if (contentChildren == null) {
            throw new IllegalArgumentException("contentChildren may not be null");
        }
        List<IContentPart> childContentParts = PartUtils.filterParts(this.getHost().getChildrenUnmodifiable(), IContentPart.class);
        HashMap<Object, IContentPart> contentPartMap = new HashMap<Object, IContentPart>();
        HashSet<? extends Object> newContents = new HashSet<Object>(contentChildren);
        ArrayList<IContentPart> toRemove = new ArrayList<IContentPart>();
        for (IContentPart iContentPart : childContentParts) {
            contentPartMap.put(iContentPart.getContent(), iContentPart);
            if (newContents.contains(iContentPart.getContent())) continue;
            toRemove.add(iContentPart);
        }
        childContentParts.removeAll(toRemove);
        for (IContentPart iContentPart : toRemove) {
            this.getHost().removeChild(iContentPart);
            this.disposeIfObsolete(iContentPart);
        }
        int contentChildrenSize = contentChildren.size();
        int childContentPartsSize = childContentParts.size();
        int i = 0;
        while (i < contentChildrenSize) {
            Object object = contentChildren.get(i);
            if (i >= childContentPartsSize || childContentParts.get(i).getContent() != object) {
                IContentPart<VR, VR> contentPart = (IContentPart<VR, VR>)contentPartMap.get(object);
                if (contentPart != null) {
                    this.getHost().reorderChild(contentPart, i);
                } else {
                    contentPart = this.findOrCreatePartFor(object);
                    if (contentPart.getParent() != null) {
                        throw new IllegalStateException("Located a ContentPart which controls the same (or an equal) content element but is already bound to a parent. A content element may only be controlled by a single ContentPart.");
                    }
                    this.getHost().addChild(contentPart, i);
                }
            }
            ++i;
        }
    }
}

