/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.parts;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.InjectAdapters;
import org.eclipse.gef4.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef4.common.beans.property.ReadOnlyMultisetProperty;
import org.eclipse.gef4.common.beans.property.ReadOnlyMultisetWrapper;
import org.eclipse.gef4.common.beans.property.ReadOnlySetMultimapProperty;
import org.eclipse.gef4.common.beans.property.ReadOnlySetMultimapWrapper;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.common.collections.ObservableMultiset;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractVisualPart<VR, V extends VR>
implements IVisualPart<VR, V> {
    private static final String DEFAULT_ANCHORAGE_ROLE = "default";
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private AdaptableSupport<IVisualPart<VR, V>> ads = new AdaptableSupport((IAdaptable)this);
    private ReadOnlyObjectWrapper<IVisualPart<VR, ? extends VR>> parentProperty = new ReadOnlyObjectWrapper();
    private ObservableList<IVisualPart<VR, ? extends VR>> children = CollectionUtils.observableArrayList();
    private ObservableList<IVisualPart<VR, ? extends VR>> childrenUnmodifiable;
    private ReadOnlyListWrapperEx<IVisualPart<VR, ? extends VR>> childrenUnmodifiableProperty;
    private ObservableSetMultimap<IVisualPart<VR, ? extends VR>, String> anchorages = CollectionUtils.observableHashMultimap();
    private ObservableSetMultimap<IVisualPart<VR, ? extends VR>, String> anchoragesUnmodifiable;
    private ReadOnlySetMultimapWrapper<IVisualPart<VR, ? extends VR>, String> anchoragesUnmodifiableProperty;
    private ObservableMultiset<IVisualPart<VR, ? extends VR>> anchoreds = CollectionUtils.observableHashMultiset();
    private ObservableMultiset<IVisualPart<VR, ? extends VR>> anchoredsUnmodifiable;
    private ReadOnlyMultisetWrapper<IVisualPart<VR, ? extends VR>> anchoredsUnmodifiableProperty;
    private BooleanProperty refreshVisualProperty = new SimpleBooleanProperty((Object)this, "refreshVisual", true);
    private V visual;

    public final void activate() {
        if (!this.acs.isActive()) {
            this.acs.activate();
            this.activateChildren();
            this.doActivate();
        }
    }

    protected void activateChildren() {
        for (IVisualPart child : this.children) {
            child.activate();
        }
    }

    public ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    @Override
    public void addChild(IVisualPart<VR, ? extends VR> child) {
        this.addChild(child, this.children.size());
    }

    @Override
    public void addChild(IVisualPart<VR, ? extends VR> child, int index) {
        if (this.children.contains(child)) {
            throw new IllegalArgumentException("Cannot add " + child + " as child of " + this + " because its already a child.");
        }
        this.children.add(index, child);
        child.setParent(this);
        this.refreshVisual();
        this.addChildVisual(child, index);
        child.refreshVisual();
        if (this.isActive()) {
            child.activate();
        }
    }

    @Override
    public void addChildren(List<? extends IVisualPart<VR, ? extends VR>> children) {
        this.addChildren(children, this.children.size());
    }

    @Override
    public void addChildren(List<? extends IVisualPart<VR, ? extends VR>> children, int index) {
        if (!Collections.disjoint(this.children, children)) {
            ArrayList<? extends IVisualPart<VR, ? extends VR>> alreadyContainedChildren = new ArrayList<IVisualPart<VR, ? extends VR>>(children);
            children.retainAll((Collection<?>)this.children);
            throw new IllegalArgumentException("Cannot add " + children + " as children of " + this + " because the following are already children: " + alreadyContainedChildren + ".");
        }
        int i = 0;
        while (i < children.size()) {
            this.addChild(children.get(i), index + i);
            ++i;
        }
    }

    protected void addChildVisual(IVisualPart<VR, ? extends VR> child, int index) {
        throw new UnsupportedOperationException("Need to properly implement addChildVisual(IVisualPart, int) for " + this.getClass());
    }

    @Override
    public ReadOnlySetMultimapProperty<IVisualPart<VR, ? extends VR>, String> anchoragesUnmodifiableProperty() {
        if (this.anchoragesUnmodifiableProperty == null) {
            this.anchoragesUnmodifiableProperty = new ReadOnlySetMultimapWrapper(this.getAnchoragesUnmodifiable());
        }
        return this.anchoragesUnmodifiableProperty.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyMultisetProperty<IVisualPart<VR, ? extends VR>> anchoredsUnmodifiableProperty() {
        if (this.anchoredsUnmodifiableProperty == null) {
            this.anchoredsUnmodifiableProperty = new ReadOnlyMultisetWrapper(this.getAnchoredsUnmodifiable());
        }
        return this.anchoredsUnmodifiableProperty.getReadOnlyProperty();
    }

    @Override
    public void attachAnchored(IVisualPart<VR, ? extends VR> anchored) {
        IViewer<VR> oldViewer = this.getViewer();
        HashMultiset newAnchoreds = HashMultiset.create(this.anchoreds);
        newAnchoreds.add(anchored);
        IViewer<VR> newViewer = this.determineViewer((IVisualPart<VR, ? extends VR>)this.getParent(), (Multiset<IVisualPart<VR, ? extends VR>>)newAnchoreds);
        if (oldViewer == null && newViewer != null) {
            this.register(newViewer);
        }
        this.anchoreds.add(anchored);
    }

    @Override
    public void attachToAnchorage(IVisualPart<VR, ? extends VR> anchorage) {
        this.attachToAnchorage(anchorage, DEFAULT_ANCHORAGE_ROLE);
    }

    @Override
    public void attachToAnchorage(IVisualPart<VR, ? extends VR> anchorage, String role) {
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null.");
        }
        if (this.anchorages.containsEntry(anchorage, (Object)role)) {
            throw new IllegalArgumentException("Already attached to anchorage " + anchorage + " with role '" + role + "'.");
        }
        this.anchorages.put(anchorage, (Object)role);
        anchorage.attachAnchored(this);
        anchorage.refreshVisual();
        this.attachToAnchorageVisual(anchorage, role);
        this.refreshVisual();
    }

    protected void attachToAnchorageVisual(IVisualPart<VR, ? extends VR> anchorage, String role) {
        throw new UnsupportedOperationException("Need to implement attachToAnchorageVisual(IVisualPart, String) for " + this.getClass());
    }

    @Override
    public ReadOnlyListProperty<IVisualPart<VR, ? extends VR>> childrenProperty() {
        if (this.childrenUnmodifiableProperty == null) {
            this.childrenUnmodifiableProperty = new ReadOnlyListWrapperEx((Object)this, "children", this.getChildrenUnmodifiable());
        }
        return this.childrenUnmodifiableProperty.getReadOnlyProperty();
    }

    protected abstract V createVisual();

    public final void deactivate() {
        if (this.acs.isActive()) {
            this.doDeactivate();
            this.deactivateChildren();
            this.acs.deactivate();
        }
    }

    protected void deactivateChildren() {
        for (IVisualPart child : this.children) {
            child.deactivate();
        }
    }

    @Override
    public void detachAnchored(IVisualPart<VR, ? extends VR> anchored) {
        IViewer<VR> oldViewer = this.getViewer();
        HashMultiset oldAnchoreds = HashMultiset.create(this.anchoreds);
        oldAnchoreds.remove(anchored);
        IViewer<VR> newViewer = this.determineViewer((IVisualPart<VR, ? extends VR>)this.getParent(), (Multiset<IVisualPart<VR, ? extends VR>>)oldAnchoreds);
        if (oldViewer != null && newViewer == null) {
            this.unregister(oldViewer);
        }
        this.anchoreds.remove(anchored);
    }

    @Override
    public void detachFromAnchorage(IVisualPart<VR, ? extends VR> anchorage) {
        this.detachFromAnchorage(anchorage, DEFAULT_ANCHORAGE_ROLE);
    }

    @Override
    public void detachFromAnchorage(IVisualPart<VR, ? extends VR> anchorage, String role) {
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null.");
        }
        if (!this.anchorages.containsEntry(anchorage, (Object)role)) {
            throw new IllegalArgumentException("Not attached to anchorage " + anchorage + " with role '" + role + "'.");
        }
        this.detachFromAnchorageVisual(anchorage, role);
        anchorage.detachAnchored(this);
        this.anchorages.remove(anchorage, (Object)role);
    }

    protected void detachFromAnchorageVisual(IVisualPart<VR, ? extends VR> anchorage, String role) {
        throw new UnsupportedOperationException("Need to implement detachFromAnchorageVisual(IVisualPart, String) for " + this.getClass());
    }

    protected IViewer<VR> determineViewer(IVisualPart<VR, ? extends VR> parent, Multiset<IVisualPart<VR, ? extends VR>> anchoreds) {
        IViewer<VR> newViewer = null;
        if (parent != null && parent.getRoot() != null) {
            newViewer = parent.getRoot().getViewer();
        } else {
            for (IVisualPart anchored : anchoreds.elementSet()) {
                IRootPart root;
                if (anchored instanceof IFeedbackPart || anchored instanceof IHandlePart || (root = anchored.getRoot()) == null) continue;
                newViewer = root.getViewer();
                break;
            }
        }
        return newViewer;
    }

    public void dispose() {
        this.ads.dispose();
    }

    protected void doActivate() {
    }

    protected void doDeactivate() {
    }

    protected abstract void doRefreshVisual(V var1);

    public <T> T getAdapter(AdapterKey<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> AdapterKey<T> getAdapterKey(T adapter) {
        return this.ads.getAdapterKey(adapter);
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public ObservableSetMultimap<IVisualPart<VR, ? extends VR>, String> getAnchoragesUnmodifiable() {
        if (this.anchoragesUnmodifiable == null) {
            this.anchoragesUnmodifiable = CollectionUtils.unmodifiableObservableSetMultimap(this.anchorages);
        }
        return this.anchoragesUnmodifiable;
    }

    @Override
    public ObservableMultiset<IVisualPart<VR, ? extends VR>> getAnchoredsUnmodifiable() {
        if (this.anchoredsUnmodifiable == null) {
            this.anchoredsUnmodifiable = CollectionUtils.unmodifiableObservableMultiset(this.anchoreds);
        }
        return this.anchoredsUnmodifiable;
    }

    @Override
    public Map<AdapterKey<? extends IBehavior<VR>>, IBehavior<VR>> getBehaviors() {
        return this.ads.getAdapters(IBehavior.class);
    }

    @Override
    public ObservableList<IVisualPart<VR, ? extends VR>> getChildrenUnmodifiable() {
        if (this.childrenUnmodifiable == null) {
            this.childrenUnmodifiable = FXCollections.unmodifiableObservableList(this.children);
        }
        return this.childrenUnmodifiable;
    }

    @Override
    public IVisualPart<VR, ? extends VR> getParent() {
        return (IVisualPart)this.parentProperty.get();
    }

    @Override
    public Map<AdapterKey<? extends IPolicy<VR>>, IPolicy<VR>> getPolicies() {
        return this.ads.getAdapters(IPolicy.class);
    }

    @Override
    public IRootPart<VR, ? extends VR> getRoot() {
        IRootPart<VR, VR> root;
        if (this.getParent() != null && (root = this.getParent().getRoot()) != null) {
            return root;
        }
        for (IVisualPart anchored : this.getAnchoredsUnmodifiable().elementSet()) {
            IRootPart root2;
            if (anchored instanceof IFeedbackPart || anchored instanceof IHandlePart || (root2 = anchored.getRoot()) == null) continue;
            return root2;
        }
        return null;
    }

    protected IViewer<VR> getViewer() {
        IRootPart<VR, VR> root = this.getRoot();
        if (root == null) {
            return null;
        }
        return root.getViewer();
    }

    @Override
    public V getVisual() {
        if (this.visual == null) {
            this.visual = this.createVisual();
            IViewer<VR> viewer = this.getViewer();
            if (viewer != null) {
                this.registerAtVisualPartMap(viewer, this.visual);
            }
        }
        return this.visual;
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    @Override
    public boolean isRefreshVisual() {
        return this.refreshVisualProperty.get();
    }

    @Override
    public ReadOnlyObjectProperty<IVisualPart<VR, ? extends VR>> parentProperty() {
        return this.parentProperty.getReadOnlyProperty();
    }

    @Override
    public final void refreshVisual() {
        if (this.visual != null && this.isRefreshVisual()) {
            this.doRefreshVisual(this.visual);
        }
    }

    @Override
    public BooleanProperty refreshVisualProperty() {
        return this.refreshVisualProperty;
    }

    protected void register(IViewer<VR> viewer) {
        if (this.visual != null) {
            this.registerAtVisualPartMap(viewer, this.visual);
        }
    }

    protected void registerAtVisualPartMap(IViewer<VR> viewer, V visual) {
        viewer.getVisualPartMap().put(visual, this);
    }

    @Override
    public void removeChild(IVisualPart<VR, ? extends VR> child) {
        if (!this.children.contains(child)) {
            throw new IllegalArgumentException("Cannot remove " + child + " as child of " + this + " because it is no child.");
        }
        if (this.isActive()) {
            child.deactivate();
        }
        this.removeChildVisual(child, this.children.indexOf(child));
        child.setParent(null);
        this.children.remove(child);
    }

    @Override
    public void removeChildren(List<? extends IVisualPart<VR, ? extends VR>> children) {
        if (!this.children.containsAll(children)) {
            ArrayList<IVisualPart<VR, VR>> arrayList = new ArrayList<IVisualPart<VR, VR>>(children);
            arrayList.removeAll((Collection<?>)this.children);
            throw new IllegalArgumentException("Cannot remove " + children + " as children of " + this + " because the following are no children: " + arrayList + ".");
        }
        for (IVisualPart<VR, VR> iVisualPart : children) {
            this.removeChild(iVisualPart);
        }
    }

    protected void removeChildVisual(IVisualPart<VR, ? extends VR> child, int index) {
        throw new UnsupportedOperationException("Need to implement removeChildVisual(IVisualPart, int) for " + this.getClass());
    }

    @Override
    public void reorderChild(IVisualPart<VR, ? extends VR> child, int index) {
        int oldIndex = this.getChildrenUnmodifiable().indexOf(child);
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Cannot reorder child " + child + " because it is no child.");
        }
        this.removeChild(child);
        this.addChild(child, index);
    }

    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    @Override
    public void setParent(IVisualPart<VR, ? extends VR> newParent) {
        IVisualPart oldParent = (IVisualPart)this.parentProperty.get();
        if (oldParent == newParent) {
            return;
        }
        IViewer<VR> oldViewer = this.getViewer();
        IViewer<? extends VR> newViewer = this.determineViewer(newParent, (Multiset<IVisualPart<VR, ? extends VR>>)this.getAnchoredsUnmodifiable());
        if (oldViewer != null && newViewer != oldViewer) {
            this.unregister(oldViewer);
        }
        if (newViewer != null && newViewer != oldViewer) {
            this.register(newViewer);
        }
        this.parentProperty.set(newParent);
    }

    @Override
    public void setRefreshVisual(boolean isRefreshVisual) {
        this.refreshVisualProperty.set(isRefreshVisual);
    }

    protected void unregister(IViewer<VR> viewer) {
        if (this.visual != null) {
            this.unregisterFromVisualPartMap(viewer, this.visual);
        }
    }

    protected void unregisterFromVisualPartMap(IViewer<VR> viewer, V visual) {
        Map<VR, IVisualPart<VR, VR>> registry = viewer.getVisualPartMap();
        if (registry.get(visual) != this) {
            throw new IllegalArgumentException("Not registered under visual");
        }
        registry.remove(visual);
    }

    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }
}

