/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.TransformContentOperation;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public abstract class AbstractTransformPolicy<VR>
extends AbstractTransactionPolicy<VR> {
    private AffineTransform initialTransform;
    private List<AffineTransform> preTransforms = new ArrayList<AffineTransform>();
    private List<AffineTransform> postTransforms = new ArrayList<AffineTransform>();

    public static Dimension getSnapToGridOffset(GridModel gridModel, double localX, double localY, double gridCellWidthFraction, double gridCellHeightFraction) {
        double snapOffsetX = 0.0;
        double snapOffsetY = 0.0;
        if (gridModel != null && gridModel.isSnapToGrid()) {
            double snapWidth = gridModel.getGridCellWidth() * gridCellWidthFraction;
            double snapHeight = gridModel.getGridCellHeight() * gridCellHeightFraction;
            snapOffsetX = localX % snapWidth;
            if (snapOffsetX > snapWidth / 2.0) {
                snapOffsetX = snapWidth - snapOffsetX;
                snapOffsetX *= -1.0;
            }
            if ((snapOffsetY = localY % snapHeight) > snapHeight / 2.0) {
                snapOffsetY = snapHeight - snapOffsetY;
                snapOffsetY *= -1.0;
            }
        }
        return new Dimension(snapOffsetX, snapOffsetY);
    }

    protected void applyTransform(AffineTransform finalTransform) {
        this.updateTransformOperation(finalTransform);
        this.locallyExecuteOperation();
    }

    @Override
    public ITransactionalOperation commit() {
        ITransactionalOperation commitOperation = super.commit();
        if (commitOperation != null && !commitOperation.isNoOp() && this.isContentTransformable()) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Transform Content");
            composite.add(commitOperation);
            composite.add(this.createTransformContentOperation());
            commitOperation = composite;
        }
        this.preTransforms.clear();
        this.postTransforms.clear();
        this.initialTransform = null;
        return commitOperation;
    }

    public int createPostTransform() {
        this.checkInitialized();
        this.postTransforms.add(new AffineTransform());
        return this.postTransforms.size() - 1;
    }

    public int createPreTransform() {
        this.checkInitialized();
        this.preTransforms.add(new AffineTransform());
        return this.preTransforms.size() - 1;
    }

    protected ITransactionalOperation createTransformContentOperation() {
        AffineTransform delta = this.getInitialTransform().getInverse().preConcatenate(this.getCurrentTransform());
        TransformContentOperation transformContentOperation = new TransformContentOperation((ITransformableContentPart)this.getHost(), delta);
        return transformContentOperation;
    }

    public abstract AffineTransform getCurrentTransform();

    public AffineTransform getInitialTransform() {
        return this.initialTransform;
    }

    @Override
    public void init() {
        this.preTransforms.clear();
        this.postTransforms.clear();
        this.initialTransform = this.getCurrentTransform();
        super.init();
    }

    protected boolean isContentTransformable() {
        return this.getHost() instanceof ITransformableContentPart;
    }

    public void setPostRotate(int index, Angle rotation) {
        this.checkInitialized();
        this.postTransforms.get(index).setToRotation(rotation.rad());
        this.updateTransform();
    }

    public void setPostScale(int index, double sx, double sy) {
        this.checkInitialized();
        this.postTransforms.get(index).setToScale(sx, sy);
        this.updateTransform();
    }

    public void setPostTransform(int postTransformIndex, AffineTransform transform) {
        this.checkInitialized();
        this.postTransforms.get(postTransformIndex).setTransform(transform);
        this.updateTransform();
    }

    public void setPostTranslate(int index, double tx, double ty) {
        this.checkInitialized();
        this.postTransforms.get(index).setToTranslation(tx, ty);
        this.updateTransform();
    }

    public void setPreRotate(int index, Angle rotation) {
        this.checkInitialized();
        this.preTransforms.get(index).setToRotation(rotation.rad());
        this.updateTransform();
    }

    public void setPreScale(int index, double sx, double sy) {
        this.checkInitialized();
        this.preTransforms.get(index).setToScale(sx, sy);
        this.updateTransform();
    }

    public void setPreTransform(int preTransformIndex, AffineTransform transform) {
        this.checkInitialized();
        this.preTransforms.get(preTransformIndex).setTransform(transform);
        this.updateTransform();
    }

    public void setPreTranslate(int index, double tx, double ty) {
        this.checkInitialized();
        this.preTransforms.get(index).setToTranslation(tx, ty);
        this.updateTransform();
    }

    public void setTransform(AffineTransform finalTransform) {
        this.checkInitialized();
        this.preTransforms.clear();
        this.postTransforms.clear();
        this.applyTransform(finalTransform);
    }

    protected void updateTransform() {
        AffineTransform composite = new AffineTransform();
        int i = this.postTransforms.size() - 1;
        while (i >= 0) {
            composite.concatenate(this.postTransforms.get(i));
            --i;
        }
        composite.concatenate(this.initialTransform);
        for (AffineTransform pre : this.preTransforms) {
            composite.concatenate(pre);
        }
        this.applyTransform(composite);
    }

    protected abstract void updateTransformOperation(AffineTransform var1);
}

