/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import com.google.common.collect.HashMultiset;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.ChangeFocusOperation;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.ContentPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class DeletionPolicy<VR>
extends AbstractTransactionPolicy<VR> {
    @Override
    protected ITransactionalOperation createOperation() {
        ReverseUndoCompositeOperation commit = new ReverseUndoCompositeOperation("Delete Content");
        IViewer viewer = this.getHost().getRoot().getViewer();
        commit.add(new ChangeFocusOperation(viewer, ((FocusModel)viewer.getAdapter(new TypeToken<FocusModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.getHost().getRoot().getViewer().getClass())))).getFocus()));
        commit.add(new DeselectOperation(viewer, Collections.emptyList()));
        commit.add(new ReverseUndoCompositeOperation("Detach anchorages"));
        commit.add(new ReverseUndoCompositeOperation("Remove children"));
        return commit;
    }

    public void delete(IContentPart<VR, ? extends VR> contentPartToDelete) {
        this.checkInitialized();
        this.getDeselectOperation().getToBeDeselected().add(contentPartToDelete);
        FocusModel focusModel = (FocusModel)this.getHost().getRoot().getViewer().getAdapter(new TypeToken<FocusModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.getHost().getRoot().getViewer().getClass())));
        if (focusModel != null && focusModel.getFocus() == contentPartToDelete) {
            this.getUnfocusOperation().setNewFocused(null);
        }
        this.locallyExecuteOperation();
        for (IVisualPart anchored : HashMultiset.create(contentPartToDelete.getAnchoredsUnmodifiable())) {
            ContentPolicy anchoredContentPolicy;
            if (!(anchored instanceof IContentPart) || (anchoredContentPolicy = (ContentPolicy)anchored.getAdapter(new TypeToken<ContentPolicy<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.getHost().getRoot().getViewer().getClass())))) == null) continue;
            anchoredContentPolicy.init();
            for (String role : anchored.getAnchoragesUnmodifiable().get(contentPartToDelete)) {
                anchoredContentPolicy.detachFromContentAnchorage(contentPartToDelete.getContent(), role);
            }
            ITransactionalOperation detachAnchoredOperation = anchoredContentPolicy.commit();
            if (detachAnchoredOperation == null || detachAnchoredOperation.isNoOp()) continue;
            this.getDetachAnchoragesOperation().add(detachAnchoredOperation);
        }
        ContentPolicy parentContentPolicy = (ContentPolicy)contentPartToDelete.getParent().getAdapter(new TypeToken<ContentPolicy<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.getHost().getRoot().getViewer().getClass())));
        if (parentContentPolicy != null) {
            parentContentPolicy.init();
            parentContentPolicy.removeContentChild(contentPartToDelete.getContent());
            ITransactionalOperation removeFromParentOperation = parentContentPolicy.commit();
            if (removeFromParentOperation != null && !removeFromParentOperation.isNoOp()) {
                this.getRemoveChildrenOperation().add(removeFromParentOperation);
            }
        }
        this.locallyExecuteOperation();
        if (!contentPartToDelete.getAnchoredsUnmodifiable().isEmpty()) {
            throw new IllegalStateException("After deletion of <" + contentPartToDelete + "> there are still anchoreds remaining.");
        }
    }

    protected AbstractCompositeOperation getCompositeOperation() {
        return (AbstractCompositeOperation)this.getOperation();
    }

    protected DeselectOperation<VR> getDeselectOperation() {
        return (DeselectOperation)this.getCompositeOperation().getOperations().get(1);
    }

    protected AbstractCompositeOperation getDetachAnchoragesOperation() {
        return (AbstractCompositeOperation)this.getCompositeOperation().getOperations().get(2);
    }

    protected AbstractCompositeOperation getRemoveChildrenOperation() {
        return (AbstractCompositeOperation)this.getCompositeOperation().getOperations().get(3);
    }

    protected ChangeFocusOperation<VR> getUnfocusOperation() {
        return (ChangeFocusOperation)this.getCompositeOperation().getOperations().get(0);
    }
}

