/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Parent;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutFilter;
import org.eclipse.gef4.layout.LayoutContext;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.models.NavigationModel;
import org.eclipse.gef4.zest.fx.parts.GraphPart;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class GraphLayoutBehavior
extends AbstractLayoutBehavior {
    private Runnable postLayout = new Runnable(){

        @Override
        public void run() {
            GraphLayoutBehavior.this.postLayout();
        }
    };
    private Runnable preLayout = new Runnable(){

        @Override
        public void run() {
            GraphLayoutBehavior.this.preLayout();
        }
    };
    private Parent nestingVisual;
    private ChangeListener<? super Bounds> nestingVisualLayoutBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            GraphLayoutBehavior.this.updateBounds();
        }
    };
    private ChangeListener<? super Bounds> viewportBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            GraphLayoutBehavior.this.updateBounds();
        }
    };

    public void applyLayout(boolean clean) {
        Graph graph = this.getHost().getContent();
        LayoutContext layoutContext = this.getLayoutContext();
        ILayoutAlgorithm layoutAlgorithm = ZestProperties.getLayoutAlgorithm(graph);
        if (layoutAlgorithm != null) {
            if (layoutContext.getLayoutAlgorithm() != layoutAlgorithm) {
                layoutContext.setLayoutAlgorithm(layoutAlgorithm);
            }
        } else if (layoutContext.getLayoutAlgorithm() != null) {
            layoutContext.setLayoutAlgorithm(null);
        }
        if (layoutContext.getGraph() != graph) {
            layoutContext.setGraph(graph);
        }
        layoutContext.applyLayout(true);
    }

    protected Rectangle computeLayoutBounds() {
        Rectangle newBounds = new Rectangle();
        if (this.nestingVisual != null) {
            Bounds layoutBounds = this.nestingVisual.getLayoutBounds();
            newBounds = new Rectangle(0.0, 0.0, layoutBounds.getWidth() / 0.25, layoutBounds.getHeight() / 0.25);
        } else {
            InfiniteCanvas canvas = this.getInfiniteCanvas();
            newBounds = new Rectangle(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        }
        return newBounds;
    }

    protected void doActivate() {
        boolean isViewportChanged;
        NavigationModel navigationModel;
        LayoutContext layoutContext = this.getLayoutContext();
        layoutContext.schedulePreLayoutPass(this.preLayout);
        layoutContext.schedulePostLayoutPass(this.postLayout);
        if (this.getHost().getParent() == this.getHost().getRoot()) {
            this.getInfiniteCanvas().scrollableBoundsProperty().addListener(this.viewportBoundsChangeListener);
        } else {
            this.nestingVisual = ((Group)this.getHost().getVisual()).getParent();
            this.nestingVisual.layoutBoundsProperty().addListener(this.nestingVisualLayoutBoundsChangeListener);
        }
        final HidingModel hidingModel = (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
        if (hidingModel != null) {
            this.getLayoutContext().addLayoutFilter(new ILayoutFilter(){

                public boolean isLayoutIrrelevant(Edge edge) {
                    return Boolean.TRUE.equals(ZestProperties.getLayoutIrrelevant(edge)) || this.isLayoutIrrelevant(edge.getSource()) || this.isLayoutIrrelevant(edge.getTarget());
                }

                public boolean isLayoutIrrelevant(Node node) {
                    return Boolean.TRUE.equals(ZestProperties.getLayoutIrrelevant(node)) || hidingModel.isHidden(node);
                }
            });
        }
        NavigationModel.ViewportState savedViewport = (navigationModel = (NavigationModel)this.getHost().getRoot().getViewer().getAdapter(NavigationModel.class)) == null ? null : navigationModel.getViewportState(this.getHost().getContent());
        InfiniteCanvas canvas = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas();
        boolean isNested = this.getNestingPart() != null;
        boolean bl = isViewportChanged = savedViewport != null && (savedViewport.getWidth() != canvas.getWidth() || savedViewport.getHeight() != canvas.getHeight());
        if (savedViewport == null || isNested || isViewportChanged) {
            LayoutProperties.setBounds((Graph)this.getHost().getContent(), (Rectangle)this.computeLayoutBounds());
            this.applyLayout(true);
        }
    }

    protected void doDeactivate() {
        LayoutContext layoutContext = this.getLayoutContext();
        layoutContext.unschedulePreLayoutPass(this.preLayout);
        layoutContext.unschedulePostLayoutPass(this.postLayout);
        if (this.nestingVisual != null) {
            this.nestingVisual.layoutBoundsProperty().removeListener(this.nestingVisualLayoutBoundsChangeListener);
        } else {
            this.getInfiniteCanvas().scrollableBoundsProperty().removeListener(this.viewportBoundsChangeListener);
        }
        this.nestingVisual = null;
    }

    public GraphPart getHost() {
        return (GraphPart)super.getHost();
    }

    protected InfiniteCanvas getInfiniteCanvas() {
        return ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas();
    }

    @Override
    protected LayoutContext getLayoutContext() {
        return (LayoutContext)this.getHost().getAdapter(LayoutContext.class);
    }

    protected NodePart getNestingPart() {
        if (this.getHost().getParent() instanceof NodePart) {
            return (NodePart)this.getHost().getParent();
        }
        return null;
    }

    @Override
    protected void postLayout() {
        for (IVisualPart child : this.getHost().getChildrenUnmodifiable()) {
            AbstractLayoutBehavior childLayoutBehavior = (AbstractLayoutBehavior)((Object)child.getAdapter(AbstractLayoutBehavior.class));
            if (childLayoutBehavior == null) continue;
            childLayoutBehavior.postLayout();
        }
    }

    @Override
    protected void preLayout() {
        for (IVisualPart child : this.getHost().getChildrenUnmodifiable()) {
            AbstractLayoutBehavior childLayoutBehavior = (AbstractLayoutBehavior)((Object)child.getAdapter(AbstractLayoutBehavior.class));
            if (childLayoutBehavior == null) continue;
            childLayoutBehavior.preLayout();
        }
    }

    protected void updateBounds() {
        Rectangle newBounds = this.computeLayoutBounds();
        Rectangle oldBounds = LayoutProperties.getBounds((Graph)this.getHost().getContent());
        if (!(oldBounds == newBounds || oldBounds != null && oldBounds.equals((Object)newBounds))) {
            LayoutProperties.setBounds((Graph)this.getHost().getContent(), (Rectangle)newBounds);
            this.applyLayout(true);
        }
    }
}

