/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import com.google.inject.Provider;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.layout.LayoutContext;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef4.zest.fx.behaviors.GraphLayoutBehavior;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class NodeLayoutBehavior
extends AbstractLayoutBehavior {
    private Dimension preLayoutSize = null;

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    @Override
    protected LayoutContext getLayoutContext() {
        IContentPart graphPart = (IContentPart)this.getHost().getRoot().getViewer().getContentPartMap().get(this.getHost().getContent().getGraph());
        return ((GraphLayoutBehavior)((Object)graphPart.getAdapter(GraphLayoutBehavior.class))).getLayoutContext();
    }

    @Override
    protected void postLayout() {
        Point postLayoutLocation;
        org.eclipse.gef4.graph.Node content = this.getHost().getContent();
        Dimension postLayoutSize = LayoutProperties.getSize((org.eclipse.gef4.graph.Node)content);
        if (postLayoutSize != null) {
            ZestProperties.setSize(content, postLayoutSize);
        }
        if ((postLayoutLocation = LayoutProperties.getLocation((org.eclipse.gef4.graph.Node)content)) != null) {
            ZestProperties.setPosition(content, postLayoutLocation.getTranslated((postLayoutSize == null ? this.preLayoutSize : postLayoutSize).getScaled(0.5).getNegated()));
        }
        this.getHost().refreshVisual();
        this.updateLabels();
    }

    @Override
    protected void preLayout() {
        org.eclipse.gef4.graph.Node content = this.getHost().getContent();
        Node visual = (Node)this.getHost().getVisual();
        Bounds hostBounds = visual.getLayoutBounds();
        double minx = hostBounds.getMinX();
        double miny = hostBounds.getMinY();
        double maxx = hostBounds.getMaxX();
        double maxy = hostBounds.getMaxY();
        Affine transform = (Affine)((Provider)this.getHost().getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get();
        this.preLayoutSize = ZestProperties.getSize(content) != null ? ZestProperties.getSize(content).getCopy() : new Dimension(maxx - minx, maxy - miny);
        LayoutProperties.setSize((org.eclipse.gef4.graph.Node)content, (Dimension)this.preLayoutSize.getCopy());
        if (ZestProperties.getPosition(content) != null) {
            LayoutProperties.setLocation((org.eclipse.gef4.graph.Node)content, (Point)ZestProperties.getPosition(content).getTranslated(this.preLayoutSize.getScaled(0.5)));
        } else {
            LayoutProperties.setLocation((org.eclipse.gef4.graph.Node)content, (Point)new Point(transform.getTx() + minx + (maxx - minx) / 2.0, transform.getTy() + miny + (maxy - miny) / 2.0));
        }
        LayoutProperties.setResizable((org.eclipse.gef4.graph.Node)content, (boolean)visual.isResizable());
    }
}

