/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class HideOperation
extends AbstractOperation
implements ITransactionalOperation {
    private NodePart nodePart;
    private IViewer<Node> viewer;
    private HidingModel hidingModel;
    private boolean initialHiddenStatus;

    public HideOperation(IViewer<Node> viewer, NodePart nodePart) {
        super("Hide");
        this.viewer = viewer;
        this.nodePart = nodePart;
        this.hidingModel = (HidingModel)viewer.getAdapter(HidingModel.class);
        this.initialHiddenStatus = this.hidingModel.isHidden(nodePart);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!((HidingModel)this.viewer.getAdapter(HidingModel.class)).isHidden(this.nodePart)) {
            this.hidingModel.hide(this.nodePart);
            this.nodePart.deactivate();
        }
        return Status.OK_STATUS;
    }

    public boolean isContentRelevant() {
        return false;
    }

    public boolean isNoOp() {
        return this.initialHiddenStatus;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (((HidingModel)this.viewer.getAdapter(HidingModel.class)).isHidden(this.nodePart)) {
            this.nodePart.activate();
            this.hidingModel.show(this.nodePart);
        }
        return Status.OK_STATUS;
    }
}

