/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.policies;

import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.mvc.fx.operations.FXTransformOperation;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.parts.AbstractLabelPart;

public class TransformLabelPolicy
extends FXTransformPolicy {
    private Point initialOffset;

    private IContentPart<Node, ? extends Node> getFirstAnchorage() {
        return (IContentPart)this.getHost().getAnchoragesUnmodifiable().keySet().iterator().next();
    }

    public AbstractLabelPart getHost() {
        return (AbstractLabelPart)super.getHost();
    }

    private Point getLabelOffsetInParent() {
        Point labelPositionInScene = this.getHost().getStoredLabelPosition();
        if (labelPositionInScene == null) {
            return null;
        }
        Point referencePositionInScene = this.getLabelReferencePointInScene((String)this.getHost().getContent().getValue());
        Point labelOffset = NodeUtils.sceneToLocal((Node)((Group)this.getHost().getVisual()).getParent(), (Point)labelPositionInScene.getTranslated(referencePositionInScene.getNegated()));
        return labelOffset;
    }

    private Point getLabelReferencePointInScene(String labelRole) {
        IAttributeStore contentElement = (IAttributeStore)this.getHost().getContent().getKey();
        if ("element-external-label".equals(labelRole)) {
            if (contentElement instanceof org.eclipse.gef4.graph.Node) {
                return NodeUtils.localToScene((Node)((Node)this.getFirstAnchorage().getVisual()), (IGeometry)FX2Geometry.toRectangle((Bounds)((Node)this.getFirstAnchorage().getVisual()).getLayoutBounds())).getBounds().getCenter();
            }
            if (this.getHost().getContent().getKey() instanceof Edge) {
                Connection connection = (Connection)this.getFirstAnchorage().getVisual();
                return NodeUtils.localToScene((Node)connection, (Point)connection.getCenter().getTranslated(0.0, ((Group)this.getHost().getVisual()).getLayoutBounds().getHeight()));
            }
            throw new IllegalArgumentException("Unsupported element.");
        }
        if ("label".equals(labelRole)) {
            if (contentElement instanceof Edge) {
                Connection connection = (Connection)this.getFirstAnchorage().getVisual();
                return NodeUtils.localToScene((Node)connection, (Point)connection.getCenter());
            }
            throw new IllegalArgumentException("Unsupported element.");
        }
        if ("edge-source-label".equals(labelRole)) {
            Connection connection = (Connection)this.getFirstAnchorage().getVisual();
            return NodeUtils.localToScene((Node)connection, (Point)connection.getStartPoint());
        }
        if ("edge-target-label".equals(labelRole)) {
            Connection connection = (Connection)this.getFirstAnchorage().getVisual();
            return NodeUtils.localToScene((Node)connection, (Point)connection.getEndPoint());
        }
        throw new IllegalArgumentException("Unsupported content element.");
    }

    public void init() {
        super.init();
        this.initialOffset = this.getLabelOffsetInParent();
    }

    protected boolean preserveLabelOffset() {
        if (this.initialOffset == null) {
            return false;
        }
        Point currentLabelOffset = this.getLabelOffsetInParent();
        Point delta = currentLabelOffset.getTranslated(this.initialOffset.getNegated());
        FXTransformOperation op = (FXTransformOperation)this.getOperation();
        op.getNewTransform().setTx(op.getInitialTransform().getTx() - delta.x);
        op.getNewTransform().setTy(op.getInitialTransform().getTy() - delta.y);
        this.locallyExecuteOperation();
        return true;
    }
}

